/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.shop.tabs;

import io.github.lightman314.lightmanscompat.ftbchunks.FTBChunksText;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.shop.ClaimShopClientTab;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.shop.ClaimShopMenuScreen;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.shop.ClaimShopMenu;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.shop.tabs.CustomerSettingsTab;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.text.MultiLineTextEntry;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CustomerSettingsClientTab
extends ClaimShopClientTab<CustomerSettingsTab> {
    public CustomerSettingsClientTab(Object screen, CustomerSettingsTab commonTab) {
        super(screen, commonTab);
    }

    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        this.addChild(((TimeInputWidget.Builder)TimeInputWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 40, 40))).range(0L, 2592000000L).unitRange(TimeUtil.TimeUnit.MINUTE, TimeUtil.TimeUnit.DAY).startTime(shop == null ? 0L : shop.getRentDueWarning()).handler(t -> ((CustomerSettingsTab)this.commonTab).setAlertTime(t.miliseconds)).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(30, 110))).width(screenArea.width - 60)).text(FTBChunksText.BUTTON_CLAIM_SHOP_RENT_WARNING_CLEAR).addon(EasyAddonHelper.tooltip((TextEntry)FTBChunksText.TOOLTIP_CLAIM_SHOP_RENT_WARNING_CLEAR))).addon(EasyAddonHelper.activeCheck(this::hasWarningBeenGiven))).pressAction(((CustomerSettingsTab)this.commonTab)::clearAlertCache)).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(30, 140))).width(screenArea.width - 60)).text(FTBChunksText.BUTTON_CLAIM_SHOP_END_RENT).addon(EasyAddonHelper.tooltip((MultiLineTextEntry)FTBChunksText.TOOLTIP_CLAIM_SHOP_END_RENT))).addon(EasyAddonHelper.activeCheck(this::canEndRental))).pressAction(((CustomerSettingsTab)this.commonTab)::EndRentalEarly)).build());
    }

    public void renderBG(EasyGuiGraphics gui) {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        if (shop == null) {
            return;
        }
        PlayerReference customer = shop.getCustomer();
        long timeRemaining = shop.rentTimeRemaining();
        MutableComponent info = customer != null && timeRemaining > 0L ? FTBChunksText.TOOLTIP_CLAIM_SHOP_RENT_STATUS.get(new Object[]{customer.getName(true), new TimeUtil.TimeData(timeRemaining).getString(2)}) : FTBChunksText.GUI_CLAIM_SHOP_RENT_STATUS_NOT_RENTED.get(new Object[0]);
        TextRenderUtil.drawCenteredMultilineText((EasyGuiGraphics)gui, (Component)info, (int)30, (int)(((ClaimShopMenuScreen)this.screen).getXSize() - 60), (int)10, (int)0x404040);
        MutableComponent notificationInfo = shop.getRentDueWarning() > 0L ? FTBChunksText.GUI_CLAIM_SHOP_RENT_WARNING.get(new Object[]{new TimeUtil.TimeData(shop.getRentDueWarning()).getString()}) : FTBChunksText.GUI_CLAIM_SHOP_RENT_WARNING_NONE.get(new Object[0]);
        TextRenderUtil.drawCenteredMultilineText((EasyGuiGraphics)gui, (Component)notificationInfo, (int)30, (int)(((ClaimShopMenuScreen)this.screen).getXSize() - 60), (int)80, (int)0x404040);
    }

    private boolean hasWarningBeenGiven() {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        return shop != null && shop.getRentWarningGiven();
    }

    private boolean canEndRental() {
        ClaimShopData shop = ((ClaimShopMenu)this.menu).getTrader();
        return shop != null && shop.canEndRental(((ClaimShopMenu)this.menu).player);
    }

    public IconData getIcon() {
        return ItemIcon.ofItem((ItemLike)Items.PAPER);
    }

    public Component getTooltip() {
        return FTBChunksText.TOOLTIP_CLAIM_SHOP_CUSTOMER_SETTINGS.get(new Object[0]);
    }
}

