/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.menu.trader_storage;

import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.ClaimShopData;
import io.github.lightman314.lightmanscompat.ftbchunks.claim_shop.trader.client.menu.trader_storage.ClaimRentClientTab;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ClaimRentTab
extends TraderStorageTab {
    public ClaimRentTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new ClaimRentClientTab(screen, this);
    }

    public boolean canOpen(Player player) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && ((shop = (ClaimShopData)traderData).isCurrentlyRented() || shop.isRentMode())) {
            return ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
        }
        return false;
    }

    public boolean isLocked() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData) {
            ClaimShopData shop = (ClaimShopData)traderData;
            return shop.isActive() || shop.isLocked();
        }
        return true;
    }

    public void SetMaxRentPayments(int limit) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades")) {
            shop.setMaxRentPayments(limit);
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setInt("ChangeMaxPayments", limit));
            }
        }
    }

    public void SetRentDuration(long duration) {
        ClaimShopData shop;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof ClaimShopData && (shop = (ClaimShopData)traderData).hasPermission(((ITraderStorageMenu)this.menu).getPlayer(), "editTrades")) {
            shop.setRentDuration(duration);
            if (this.isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setLong("ChangeDuration", duration));
            }
        }
    }

    public void receiveMessage(LazyPacketData message) {
        if (message.contains("ChangeMaxPayments")) {
            this.SetMaxRentPayments(message.getInt("ChangeMaxPayments"));
        }
        if (message.contains("ChangeDuration")) {
            this.SetRentDuration(message.getLong("ChangeDuration"));
        }
    }
}

