/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscompat.waystones.requirements;

import io.github.lightman314.lightmanscompat.waystones.WaystonesText;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import net.blay09.mods.waystones.api.requirement.RequirementType;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record MoneyRequirement(MoneyValue price) implements WarpRequirement
{
    public static final ResourceLocation ID = VersionUtil.modResource((String)"lcompat", (String)"money_requirement");
    public static final RequirementType<MoneyRequirement> TYPE = new Type();

    public MoneyRequirement() {
        this(MoneyValue.empty());
    }

    public boolean canAfford(Player player) {
        IMoneyHolder handler = MoneyAPI.getApi().GetPlayersMoneyHandler(player);
        return handler.getStoredMoney().containsValue(this.price);
    }

    public void consume(Player player) {
        IMoneyHolder handler = MoneyAPI.getApi().GetPlayersMoneyHandler(player);
        handler.extractMoney(this.price, false);
    }

    public void rollback(Player player) {
        IMoneyHolder handler = MoneyAPI.getApi().GetPlayersMoneyHandler(player);
        handler.insertMoney(this.price, false);
    }

    public void appendHoverText(Player player, List<Component> tooltip) {
        if (this.price.isEmpty()) {
            return;
        }
        tooltip.add((Component)WaystonesText.TOOLTIP_WAYSTONE_MONEY_COST.get(new Object[]{this.price.getText()}));
    }

    public boolean isEmpty() {
        return this.price.isEmpty();
    }

    private static class Type
    implements RequirementType<MoneyRequirement> {
        private Type() {
        }

        public ResourceLocation getId() {
            return ID;
        }

        public MoneyRequirement createInstance() {
            return new MoneyRequirement();
        }
    }
}

