package silveon22.deep.mixins;

import net.minecraft.core.block.*;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.overworld.ChunkDecoratorOverworld;
import net.minecraft.core.world.generate.feature.*;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import silveon22.deep.block.DEEPBlocks;
import silveon22.deep.block.ore.BlockLogicAmethystOre;
import silveon22.deep.block.ore.BlockLogicLeadOre;
import silveon22.deep.block.ore.BlockLogicSilverOre;
import silveon22.deep.block.ore.BlockLogicUraniumOre;
import silveon22.deep.worldfeatures.WorldFeatureCattail;
import silveon22.deep.worldfeatures.WorldFeatureCoral;
import silveon22.deep.worldfeatures.WorldFeatureLilypad;

import java.util.Random;

@Mixin(value = ChunkDecoratorOverworld.class, remap = false)
public class ChunkDecoratorOverworldMixin {
	@Shadow
	@Final
	private World world;

	@Inject(method = "decorate(Lnet/minecraft/core/world/chunk/Chunk;)V", at = @At(value = "TAIL"))
	public void addCustomOre(Chunk chunk, CallbackInfo ci) {
		BlockLogicSand.fallInstantly = true;

		int chunkX = chunk.xPosition;
		int chunkZ = chunk.zPosition;
		int minY = this.world.getWorldType().getMinY();
		int maxY = this.world.getWorldType().getMaxY();
		int rangeY = maxY + 1 - minY;
		float oreHeightModifier = (float)rangeY / 128.0F;
		Random rand = new Random((long)chunkX * 341873898712L + (long)chunkZ * 132696981241L);

		BlockLogicSand.fallInstantly = true;
		int x = chunkX * 16;
		int z = chunkZ * 16;
		int y = this.world.getHeightValue(x + 16, z + 16);
		Biome biome = this.world.getBlockBiome(x + 16, y, z + 16);

		for(int i4 = 0; (float)i4 < oreHeightModifier; ++i4) {
			int j7 = x + rand.nextInt(16);
			int k10 = minY + rand.nextInt(rangeY / 8);
			int j13 = z + rand.nextInt(16);
			(new WorldFeatureOre(BlockLogicAmethystOre.variantMap, 7)).place(this.world, rand, j7, k10, j13);
		}

		for(int k3 = 0; (float)k3 < 2.0F * oreHeightModifier; ++k3) {
			int l6 = x + rand.nextInt(16);
			int i10 = minY + rand.nextInt(rangeY / 6);
			int l12 = z + rand.nextInt(16);
			(new WorldFeatureOre(BlockLogicSilverOre.variantMap, 8)).place(this.world, rand, l6, i10, l12);
		}

		for(int i4 = 0; (float)i4 < oreHeightModifier; ++i4) {
			int j7 = x + rand.nextInt(16);
			int k10 = minY + rand.nextInt(rangeY / 4);
			int j13 = z + rand.nextInt(16);
			(new WorldFeatureOre(BlockLogicUraniumOre.variantMap, 5)).place(this.world, rand, j7, k10, j13);
		}

		for(int j3 = 0; (float)j3 < 8.0F * oreHeightModifier; ++j3) {
			int k6 = x + rand.nextInt(16);
			int l9 = minY + rand.nextInt(rangeY / 4);
			int k12 = z + rand.nextInt(16);
			(new WorldFeatureOre(BlockLogicLeadOre.variantMap, 5)).place(this.world, rand, k6, l9, k12);
		}

		if (rand.nextInt(1) == 0) {
			int l15 = x + rand.nextInt(16) + 8;
			int l17 = minY + rand.nextInt(rangeY / 4);
			int l20 = z + rand.nextInt(16) + 8;
			(new WorldFeatureFlowers(DEEPBlocks.mushroomExplosive.id(), 64, false)).place(this.world, rand, l15, l17, l20);
		}

		if (rand.nextInt(2) == 0) {
			int l15 = x + rand.nextInt(16) + 8;
			int l17 = minY + rand.nextInt(rangeY / 2);
			int l20 = z + rand.nextInt(16) + 8;
			(new WorldFeatureFlowers(DEEPBlocks.mushroomBlue.id(), 64, false)).place(this.world, rand, l15, l17, l20);
		}

		if (rand.nextInt(1) == 0) {
			int l15 = x + rand.nextInt(16) + 8;
			int l17 = minY + rand.nextInt(rangeY / 5);
			int l20 = z + rand.nextInt(16) + 8;
			(new WorldFeatureFlowers(Blocks.COBWEB.id(), 64, false)).place(this.world, rand, l15, l17, l20);
		}

		if (rand.nextInt(12) == 0) {
			int j16 = x + rand.nextInt(16) + 8;
			int j21 = z + rand.nextInt(16) + 8;
			int i22 = this.world.getHeightValue(j16, j21);
			(new WorldFeatureCoral()).place(this.world, rand, j16, i22, j21);
		}
		if (rand.nextInt(3) == 0) {
			int i18 = x + rand.nextInt(16) + 8;
			int i23 = z + rand.nextInt(16) + 8;
			int i21 = this.world.getHeightValue(i18, i23);
			(new WorldFeatureCattail()).place(this.world, rand, i18, i21, i23);
		}

		int oceanY = this.world.getWorldType().getOceanY();
		if (rand.nextInt(64) == 0 && world.getBlockHumidity(x, z) > 0.5 && world.getBlockTemperature(x, z) > 0.4) {
			int j16 = x + rand.nextInt(16) + 8;
			int j21 = z + rand.nextInt(16) + 8;
			(new WorldFeatureLilypad()).place(this.world, rand, j16, oceanY - 1, j21);
		}


		BlockLogicSand.fallInstantly = false;
	}

}
