/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class MobElderSkeleton
extends MobSkeleton {
    public MobElderSkeleton(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"elder_skeleton");
        this.moveSpeed = 2.0f;
        this.scoreValue = 1000;
        this.setHealthRaw(34);
        this.mobDrops.add(new WeightedRandomLootObject(Items.AMMO_ARROW.getDefaultStack(), 2, 5));
        this.mobDrops.add(new WeightedRandomLootObject(Items.BONE.getDefaultStack(), 0, 2));
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (distance < 10.0f) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    ProjectileArrow arrow = new ProjectileArrow(this.world, (Mob)this, false, 1);
                    double d2 = entity.y + (double)entity.getHeadHeight() - 0.2 - arrow.y;
                    float f1 = MathHelper.sqrt((double)(d * d + d1 * d1)) * 0.2f;
                    this.world.playSoundAtEntity((Entity)null, (Entity)this, "random.bow", 1.0f, 1.6f / (this.random.nextFloat() * 0.4f + 0.8f));
                    arrow.setHeading(d, d2 + (double)f1, d1, 0.6f, 3.0f);
                    this.world.entityJoinedWorld((Entity)arrow);
                }
                this.attackTime = 20;
            }
            this.yRot = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
    }
}

