/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.block.Models;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;

@Environment(value=EnvType.CLIENT)
public class BlockModelLilypad<T extends BlockLogic>
extends BlockModelStandard<T> {
    private final IconCoordinate waterLilyOverlay = TextureRegistry.getTexture((String)"deep:block/waterlily");

    public BlockModelLilypad(Block<T> block) {
        super(block);
    }

    public boolean render(Tessellator tessellator, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(BlockModelLilypad.renderBlocks.blockAccess, x, y, z);
        AABB bounds2 = this.block.getBlockBoundsFromState(BlockModelLilypad.renderBlocks.blockAccess, x, y, z);
        float brightness = 1.0f;
        if (!LightmapHelper.isLightmapEnabled()) {
            brightness = this.getBlockBrightness(BlockModelLilypad.renderBlocks.blockAccess, x, y, z);
        } else {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelLilypad.renderBlocks.blockAccess, x, y, z));
        }
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)this.block)).getWorldColor(BlockModelLilypad.renderBlocks.blockAccess, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(red * brightness, green * brightness, blue * brightness);
        IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.TOP, BlockModelLilypad.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        IconCoordinate tex2 = this.getBlockTextureFromSideAndMetadata(Side.NORTH, BlockModelLilypad.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        this.renderTopFace(tessellator, bounds, x, (double)y - 0.1125, z, tex);
        this.renderBottomFace(tessellator, bounds, x, (double)y + 0.0125, z, tex);
        red = 255.0f;
        green = 255.0f;
        blue = 255.0f;
        tessellator.setColorOpaque_F(red * brightness, green * brightness, blue * brightness);
        BlockModelLilypad.renderBlocks.overrideBlockTexture = this.waterLilyOverlay;
        this.renderTopFace(tessellator, bounds2, x, (double)y - 0.0625, z, this.waterLilyOverlay);
        BlockModelLilypad.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    public boolean shouldItemRender3d() {
        return false;
    }

    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, int side) {
        return side == 1 ? true : super.shouldSideBeRendered(blockAccess, bounds, x, y, z, side);
    }

    public IconCoordinate getParticleTexture(Side side, int meta) {
        return TextureRegistry.getTexture((String)"deep:block/lilypad");
    }
}

