/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.block.misc;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.World;

public class BlockLogicEggSpider
extends BlockLogic {
    public BlockLogicEggSpider(Block<?> block) {
        super(block, Material.cloth);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    protected boolean mayPlaceOn(int blockId) {
        return Blocks.solid[blockId];
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        if (y >= 0 && y < world.getHeightBlocks()) {
            return world.getFullBlockLightValue(x, y, z) < 13 && this.mayPlaceOn(world.getBlockId(x, y - 1, z));
        }
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof Player) {
            world.scheduleBlockUpdate(x, y, z, this.block.id(), this.tickDelay());
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        world.scheduleBlockUpdate(x, y, z, this.block.id(), this.tickDelay());
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        world.setBlockWithNotify(x, y, z, 0);
    }

    public int tickDelay() {
        return 3;
    }

    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (!world.isClientSide) {
            for (int j = 0; j < 2; ++j) {
                MobSpider mobSpider = new MobSpider(world);
                mobSpider.moveTo((double)x, (double)y + (double)0.2f, (double)z, world.rand.nextFloat() * 360.0f, world.rand.nextFloat() * 360.0f);
                world.spawnParticle("snowshovel", (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, 0);
                world.entityJoinedWorld((Entity)mobSpider);
                world.playSoundEffect((Entity)null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "mob.slime", 1.0f, 0.7f);
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            default: 
        }
        return null;
    }
}

