/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.block.misc;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLilyPad
extends BlockLogic
implements IBonemealable {
    public BlockLogicLilyPad(Block<?> block) {
        super(block, Material.plant);
        this.setBlockBounds(0.0, -0.125, 0.0, 1.0, 0.00625f, 1.0);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityBoat) {
            int data = world.getBlockMetadata(x, y, z);
            world.playBlockEvent((Player)null, 2001, x, y, z, this.block.id());
            world.setBlockWithNotify(x, y, z, 0);
            this.onBlockRemoved(world, x, y, z, data);
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
        }
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int blockId = world.getBlockId(x, y, z);
        return blockId == 0 && Blocks.hasTag((int)world.getBlockId(x, y - 1, z), (Tag)BlockTags.IS_WATER) && world.getBlockMetadata(x, y - 1, z) == 0;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!Blocks.hasTag((int)world.getBlockId(x, y - 1, z), (Tag)BlockTags.IS_WATER) || world.getBlockMetadata(x, y - 1, z) != 0) {
            world.setBlock(x, y, z, 0);
        }
    }

    public boolean isSolidRender() {
        return false;
    }

    public boolean isCubeShaped() {
        return false;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            default: 
        }
        return new ItemStack[]{new ItemStack(this.block)};
    }

    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        return !(entity instanceof EntityBoat);
    }

    public boolean onBonemealUsed(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Random rand = world.rand;
        if (world.isClientSide) {
            return true;
        }
        if (player == null || player.getGamemode().consumeBlocks()) {
            --itemstack.stackSize;
        }
        block0: for (int i = 0; i < 128; ++i) {
            int _x = blockX;
            int _z = blockZ;
            for (int j = 0; j < i / 16; ++j) {
                int bId = world.getBlockId(_x += rand.nextInt(3) - 1, blockY - 1, _z += rand.nextInt(3) - 1);
                int bMeta = world.getBlockMetadata(_x, blockY - 1, _z);
                if (bId != Blocks.FLUID_WATER_FLOWING.id() && bId != Blocks.FLUID_WATER_STILL.id() || bMeta != 0) continue block0;
            }
            if (world.getBlockId(_x, blockY, _z) != 0 || !((double)rand.nextFloat() > 0.75)) continue;
            world.setBlockWithNotify(_x, blockY, _z, this.block.id());
        }
        return true;
    }
}

