/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.block.misc;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockLogicRagingSoulSand
extends BlockLogic {
    public BlockLogicRagingSoulSand(Block<?> block) {
        super(block, Material.soulsand);
    }

    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        float f = 0.125f;
        return AABB.getTemporaryBB((double)((double)x + (double)f), (double)((double)y + (double)f), (double)((double)z + (double)f), (double)((float)(x + 1) - f), (double)((float)(y + 1) - f), (double)((float)(z + 1) - f));
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        entity.xd = 0.0;
        entity.zd = 0.0;
        entity.yd = 0.0;
        if (entity instanceof Mob) {
            if (entity.tickCount % 5 == 0) {
                entity.hurt((Entity)null, 2, DamageType.GENERIC);
            }
            entity.stuckInSpikes = true;
        } else if (entity instanceof EntityItem) {
            entity.remove();
            world.playSoundEffect((Entity)null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.bite", 0.3f, 1.0f);
        }
    }
}

