/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import silveon22.deep.item.DEEPItems;

public class ItemCeramicBucket
extends Item {
    @Nullable
    private final Block<?> blockToPlace;

    public ItemCeramicBucket(String name, String namespaceId, int id, @Nullable Block<?> blockToPlace) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.blockToPlace = blockToPlace;
    }

    public ItemStack onUseItem(ItemStack stack, World world, Player player) {
        if (this.blockToPlace == null) {
            return new ItemStack((Item)DEEPItems.bucketCeramicEmpty);
        }
        double reachDistance = player.getGamemode().getBlockReachDistance();
        HitResult rayTraceResult = player.rayTrace(reachDistance, 1.0f, false, false);
        if (rayTraceResult != null && rayTraceResult.hitType == HitResult.HitType.TILE) {
            int x = rayTraceResult.x;
            int y = rayTraceResult.y;
            int z = rayTraceResult.z;
            if (!world.canMineBlock(player, x, y, z)) {
                return stack;
            }
            Block block = world.getBlock(x, y, z);
            if (block != null && !block.hasTag(BlockTags.PLACE_OVERWRITES) && !block.hasTag(BlockTags.BROKEN_BY_FLUIDS)) {
                Side side = rayTraceResult.side;
                x += side.getOffsetX();
                y += side.getOffsetY();
                z += side.getOffsetZ();
            }
            if (y >= 0 && y < world.getHeightBlocks()) {
                if (world.isAirBlock(x, y, z) || !world.getBlockMaterial(x, y, z).isSolid()) {
                    if (world.dimension == Dimension.NETHER && this.blockToPlace == Blocks.FLUID_WATER_FLOWING) {
                        world.playSoundEffect((Entity)player, SoundCategory.WORLD_SOUNDS, (double)z + 0.5, (double)y + 0.5, (double)x + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                        for (int l = 0; l < 8; ++l) {
                            world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
                        }
                    } else {
                        if (this.blockToPlace == Blocks.FLUID_WATER_FLOWING) {
                            world.playSoundEffect((Entity)player, SoundCategory.WORLD_SOUNDS, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "liquid.splash", 0.5f, 1.0f);
                        }
                        player.swingItem();
                        Block block1 = world.getBlock(x, y, z);
                        if (block1 != null) {
                            block1.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), (TileEntity)null, (Player)null);
                        }
                        world.setBlockAndMetadataWithNotify(x, y, z, this.blockToPlace.id(), 0);
                    }
                    if (player.getGamemode().consumeBlocks()) {
                        --stack.stackSize;
                    }
                }
                return stack;
            }
            return stack;
        }
        return stack;
    }

    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        if (this.blockToPlace == null) {
            itemStack.itemID = DEEPItems.bucketCeramicEmpty.id;
        } else {
            int z;
            int y;
            int x = blockX + direction.getOffsetX();
            Block b = world.getBlock(x, y = blockY + direction.getOffsetY(), z = blockZ + direction.getOffsetZ());
            if (b == null || BlockTags.PLACE_OVERWRITES.appliesTo((ITaggable)b) || BlockTags.BROKEN_BY_FLUIDS.appliesTo((ITaggable)b)) {
                world.setBlockWithNotify(x, y, z, this.blockToPlace.id());
                --itemStack.stackSize;
            }
        }
    }
}

