/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mixins;

import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolSword;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.collection.NamespaceID;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import silveon22.deep.item.DEEPItems;

@Mixin(value={ItemToolSword.class}, remap=false)
public class ItemToolSwordBismuthMixin
extends Item {
    public ItemToolSwordBismuthMixin(NamespaceID namespaceId, int id) {
        super(namespaceId, id);
    }

    @Unique
    public void setDurabilityCount(ItemStack stack, int count) {
        stack.setMetadata(stack.getMaxDamage() - count);
    }

    @Unique
    public boolean hasInventoryInteraction() {
        return true;
    }

    @Unique
    public ItemStack onInventoryInteract(Player player, Slot slot, ItemStack stackInSlot, boolean isItemGrabbed) {
        if (isItemGrabbed) {
            return stackInSlot;
        }
        int durabilityCount = this.getDurabilityCount(stackInSlot);
        ItemStack grabbedItem = player.inventory.getHeldItemStack();
        if (grabbedItem != null && grabbedItem.itemID == DEEPItems.bismuth.id && durabilityCount < this.getMaxDamage()) {
            int newDurabilityCount = Math.min(this.getMaxDamage(), stackInSlot.getMaxDamage());
            this.setDurabilityCount(stackInSlot, newDurabilityCount);
            --grabbedItem.stackSize;
            if (grabbedItem.stackSize <= 0) {
                player.inventory.setHeldItemStack((ItemStack)null);
            }
        }
        return stackInSlot;
    }

    @Unique
    public int getDurabilityCount(ItemStack stack) {
        return stack.getMaxDamage() - stack.getMetadata();
    }
}

