/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mixins;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MobCow.class}, remap=false)
public class MobCowHostileMixin
extends MobAnimal {
    @Unique
    protected int attackStrength = 7;

    public MobCowHostileMixin(World world) {
        super(world);
    }

    protected void checkForPlayerHoldingItem() {
        float distanceToEntity;
        if (this.target == null) {
            this.closestPlayer = this.world.getClosestPlayer(this.x, this.y, this.z, 10.0);
        }
        if (this.closestPlayer != null) {
            if (this.isFavouriteItem(this.closestPlayer.getHeldItem())) {
                this.setTarget((Entity)this.closestPlayer);
            } else {
                this.setTarget(null);
                this.closestPlayer = null;
            }
        }
        if (this.target != null && (distanceToEntity = this.target.distanceTo((Entity)this)) < 3.0f) {
            this.moveForward = 0.0f;
        }
        if (this.passenger != null && this.target == null) {
            this.closestPlayer = this.world.getClosestPlayer(this.x, this.y, this.z, 16.0);
            if (this.closestPlayer != null) {
                this.setTarget((Entity)this.closestPlayer);
                this.moveSpeed = 2.0f;
                this.speed = 0.13f;
            } else {
                this.moveSpeed = 0.5f;
                this.speed = 0.1f;
            }
        }
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (this.passenger != null) {
            if (distance > 2.0f && distance < 6.0f && this.random.nextInt(10) == 0) {
                if (this.onGround) {
                    double d = entity.x - this.x;
                    double d1 = entity.z - this.z;
                    float f2 = MathHelper.sqrt((double)(d * d + d1 * d1));
                    this.xd = d / (double)f2 * 0.5 * (double)0.8f + this.xd * 0.2;
                    this.zd = d1 / (double)f2 * 0.5 * (double)0.8f + this.zd * 0.2;
                    this.yd = 0.4f;
                }
            } else if (this.attackTime <= 0 && distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
                this.attackTime = 20;
                entity.hurt((Entity)this, this.attackStrength, DamageType.COMBAT);
            }
        }
    }
}

