/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import silveon22.deep.item.DEEPItems;

public class MobBeetle
extends MobSpider {
    boolean alerted = false;

    public MobBeetle(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"beetle");
        this.moveSpeed = 0.4f;
        this.attackStrength = 2;
        this.setHealthRaw(34);
        this.scoreValue = 300;
        this.mobDrops.clear();
        this.mobDrops.add(new WeightedRandomLootObject(DEEPItems.huskBeetle.getDefaultStack(), 0, 2));
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        float brightness = this.getBrightness(1.0f);
        if (brightness > 0.5f && this.random.nextInt(100) == 0) {
            this.target = null;
        } else {
            super.attackEntity(entity, distance);
        }
    }

    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int blockX = MathHelper.floor((double)this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor((double)this.bb.minY), blockZ = MathHelper.floor((double)this.z)) > 0) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 2.2f)) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }
}

