/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.MobWaterAnimal;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import silveon22.deep.item.DEEPItems;

public class MobJellyfish
extends MobWaterAnimal {
    public float xBodyRot = 0.0f;
    public float xBodyRotO = 0.0f;
    public float zBodyRot = 0.0f;
    public float zBodyRotO = 0.0f;
    public float tentacleMovement = 0.0f;
    public float oldTentacleMovement = 0.0f;
    public float tentacleAngle = 0.0f;
    public float oldTentacleAngle = 0.0f;
    private float _speed = 0.0f;
    private float tentacleSpeed = 0.0f;
    private float rotateSpeed = 0.0f;
    private float tx = 0.0f;
    private float ty = 0.0f;
    private float tz = 0.0f;

    public MobJellyfish(World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"jellyfish");
        this.setSize(0.9f, 0.9f);
        this.tentacleSpeed = 0.5f / (this.random.nextFloat() + 0.5f) * 0.2f;
        this.setHealthRaw(2);
        this.scoreValue = 25;
        this.mobDrops.add(new WeightedRandomLootObject(DEEPItems.gel.getDefaultStack(), 0, 2));
    }

    protected String getHurtSound() {
        return "mob.slime";
    }

    protected String getDeathSound() {
        return "mob.slime";
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if (this.tentacleMovement > (float)Math.PI * 2) {
            this.tentacleMovement = 0.0f;
            if (this.random.nextInt(10) == 9) {
                this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.isInWater() && !this.isSpecial()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float f = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = MathHelper.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this._speed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this._speed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.isMultiplayerEntity) {
                this.xd = this.tx * this._speed;
                this.yd = this.ty * this._speed;
                this.zd = this.tz * this._speed;
            }
            float horizontalSpeed = MathHelper.sqrt((double)(this.xd * this.xd + this.zd * this.zd));
            this.yBodyRot += (-((float)Math.atan2(this.xd, this.zd)) * 180.0f / (float)Math.PI - this.yBodyRot) * 0.1f;
            this.yRot = this.yBodyRot;
            this.zBodyRot += (float)Math.PI * this.rotateSpeed * 1.5f;
            this.xBodyRot += (-((float)Math.atan2(horizontalSpeed, this.yd)) * 180.0f / (float)Math.PI - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.abs((float)MathHelper.sin((float)this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.isSpecial()) {
                if (!this.isMultiplayerEntity) {
                    this.xd = 0.0;
                    this.yd -= 0.08;
                    this.yd *= 0.98;
                    this.zd = 0.0;
                }
                this.xBodyRot += (-90.0f - this.xBodyRot) * 0.02f;
            }
        }
    }

    public void trySuffocate() {
        if (!this.isSpecial()) {
            if (this.isAlive() && !this.isUnderLiquid(Material.water) && this.canBreatheUnderwater()) {
                --this.airSupply;
                if (this.airSupply == -20) {
                    this.airSupply = 0;
                    this.hurt(null, 2, DamageType.DROWN);
                }
                this.remainingFireTicks = 0;
            } else {
                this.airSupply = this.airMaxSupply;
            }
        }
    }

    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        if (this.isSpecial()) {
            super.moveEntityWithHeading(moveStrafing, moveForward);
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    protected void updateAI() {
        if (this.isSpecial()) {
            Player closest = this.world.getClosestPlayer(this.x, this.y, this.z, 10.0);
            if (closest != null) {
                this.setTarget((Entity)closest);
            }
            super.updateAI();
        } else {
            if (this.random.nextInt(50) == 0 || !this.wasInWater || this.tx == 0.0f && this.ty == 0.0f && this.tz == 0.0f) {
                float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
                this.tx = MathHelper.cos((float)f) * 0.2f;
                Block upwardsBlock = this.world.getBlock((int)this.x, (int)this.y + 3, (int)this.z);
                Block downwardsBlock = this.world.getBlock((int)this.x, (int)this.y - 3, (int)this.z);
                boolean isTouchingBlock = this.isTouchingBlock();
                this.ty = isTouchingBlock && this.isInWater() && !this.world.isAirBlock((int)this.x, (int)(this.y + 1.0), (int)this.z) && !this.world.isAirBlock((int)this.x, (int)(this.y + 2.0), (int)this.z) ? this.random.nextFloat() * 0.2f : (upwardsBlock != null && upwardsBlock.getMaterial() == Material.water ? (downwardsBlock != null && downwardsBlock.getMaterial() == Material.water ? -0.1f + this.random.nextFloat() * 0.2f : -0.05f + this.random.nextFloat() * 0.4f) : -0.15f + this.random.nextFloat() * 0.2f);
                this.tz = MathHelper.sin((float)f) * 0.2f;
            }
            this.tryToDespawn();
        }
    }

    public boolean isTouchingBlock() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX = MathHelper.floor((double)(this.bb.minX - 0.25));
        if (this.world.areBlocksLoaded(minX, minY = MathHelper.floor((double)(this.bb.minY - 0.25)), minZ = MathHelper.floor((double)(this.bb.minZ - 0.25)), maxX = MathHelper.floor((double)(this.bb.maxX + 0.25)), maxY = MathHelper.floor((double)(this.bb.maxY + 0.25)), maxZ = MathHelper.floor((double)(this.bb.maxZ + 0.25)))) {
            for (int _x = minX; _x <= maxX; ++_x) {
                for (int _y = minY; _y <= maxY; ++_y) {
                    for (int _z = minZ; _z <= maxZ; ++_z) {
                        Block block = this.world.getBlock(_x, _y, _z);
                        if (block == null || block.getMaterial() == Material.water) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean canSpawnHere() {
        int x = MathHelper.floor((double)this.x);
        int y = MathHelper.floor((double)this.bb.minY);
        int z = MathHelper.floor((double)this.z);
        if (!this.world.isDaytime()) {
            return super.canSpawnHere();
        }
        return false;
    }

    protected boolean makeStepSound() {
        return false;
    }

    public boolean isSpecial() {
        return "Silveon22".equals(this.nickname);
    }
}

