/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import org.jetbrains.annotations.NotNull;
import silveon22.deep.block.DEEPBlocks;
import silveon22.deep.mob.ProjectileWeb;

public class MobMotherSpider
extends MobSpider {
    boolean alerted = false;

    public MobMotherSpider(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"mother_spider");
        this.moveSpeed = 0.8f;
        this.attackStrength = 5;
        this.setHealthRaw(34);
        this.scoreValue = 1000;
        this.mobDrops.clear();
    }

    protected List<WeightedRandomLootObject> getMobDrops() {
        ArrayList<WeightedRandomLootObject> drops = new ArrayList<WeightedRandomLootObject>();
        float drop = this.world.rand.nextFloat();
        if (!(drop < 0.5f)) {
            if (drop < 0.95f) {
                drops.add(new WeightedRandomLootObject(Items.STRING.getDefaultStack(), 3, 7));
            } else {
                drops.add(new WeightedRandomLootObject(DEEPBlocks.eggSpider.getDefaultStack(), 1, 1));
            }
        }
        return drops;
    }

    public void onLivingUpdate() {
        if (!this.alerted && this.getHealth() <= 18) {
            this.alerted = true;
            this.playLivingSound();
            int backupCount = this.world.rand.nextInt(1) + 2;
            for (int k = 0; k < 20; ++k) {
                double d1 = this.x + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                double d3 = this.y + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                double d5 = this.z + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                this.world.spawnParticle("snowshovel", d1, d3, d5, 0.0, 0.0, 0.0, 0);
                this.world.spawnParticle("snowshovel", d1, d3, d5, 0.0, 0.0, 0.0, 0);
                this.world.playSoundAtEntity((Entity)null, (Entity)this, "mob.slime", 0.25f, 0.75f);
            }
            for (int j = 0; j < backupCount; ++j) {
                MobSpider mobSpider = new MobSpider(this.world);
                mobSpider.moveTo(this.x + (double)this.random.nextInt(3) - 1.0, this.y + 0.5, this.z + (double)this.random.nextInt(3) - 1.0, this.random.nextFloat() * 360.0f, this.random.nextFloat() * 360.0f);
                this.world.entityJoinedWorld((Entity)mobSpider);
            }
        }
        super.onLivingUpdate();
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        float brightness = this.getBrightness(1.0f);
        if (brightness > 0.5f && this.random.nextInt(100) == 0) {
            this.target = null;
        } else if (distance > 5.0f && distance < 12.0f) {
            double dX = entity.x - this.x;
            double dZ = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    ProjectileWeb projectileweb = new ProjectileWeb(this.world, (Mob)this);
                    double d2 = entity.y + (double)entity.getHeadHeight() - 0.2 - projectileweb.y;
                    float f1 = MathHelper.sqrt((double)(dX * dX + dZ * dZ)) * 0.2f;
                    this.world.playSoundAtEntity((Entity)null, (Entity)this, "random.bow", 0.5f, 0.4f / (this.random.nextFloat() * 0.4f + 0.8f));
                    this.world.entityJoinedWorld((Entity)projectileweb);
                    projectileweb.setHeadingPrecise(dX, d2 + (double)f1, dZ, 0.6f);
                }
                this.attackTime = 20;
            }
            this.yRot = (float)(Math.atan2(dZ, dX) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        } else {
            super.attackEntity(entity, distance);
        }
    }

    public boolean canSpawnHere() {
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int blockX = MathHelper.floor((double)this.x);
        int blockY = MathHelper.floor((double)this.bb.minY);
        int blockZ = MathHelper.floor((double)this.z);
        Biome biome = this.world.getBlockBiome((int)this.x, (int)this.y, (int)this.z);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY, blockZ) > 0) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 4.0f) && biome != Biomes.OVERWORLD_OUTBACK && biome != Biomes.OVERWORLD_OUTBACK_GRASSY) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 2.0f)) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }
}

