/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class MobNoteZombie
extends MobZombie {
    int instrument = 0;
    boolean alerted = false;

    public MobNoteZombie(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"noteblock_zombie");
        this.moveSpeed = 0.4f;
        this.attackStrength = 4;
        this.setHealthRaw(25);
        this.scoreValue = 500;
        this.mobDrops.add(new WeightedRandomLootObject(Items.CLOTH.getDefaultStack(), 0, 2));
        this.instrument = this.random.nextInt(11);
    }

    protected List<WeightedRandomLootObject> getMobDrops() {
        ArrayList<WeightedRandomLootObject> drops = new ArrayList<WeightedRandomLootObject>();
        float drop = this.world.rand.nextFloat();
        if (!(drop < 0.5f)) {
            if (drop < 0.95f) {
                drops.add(new WeightedRandomLootObject(Items.CLOTH.getDefaultStack(), 0, 2));
            } else {
                drops.add(new WeightedRandomLootObject(Blocks.NOTEBLOCK.getDefaultStack(), 1, 1));
            }
        }
        return drops;
    }

    public void onLivingUpdate() {
        if (!this.alerted && this.getHealth() <= 24) {
            this.alerted = true;
            this.playLivingSound();
            int backupCount = this.world.rand.nextInt(3) + 2;
            for (int k = 0; k < 20; ++k) {
                double d1 = this.x + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                double d3 = this.y + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                double d5 = this.z + 0.5 + ((double)this.world.rand.nextFloat() - 0.5) * 2.0;
                this.world.spawnParticle("smoke", d1, d3, d5, 0.0, 0.0, 0.0, 0);
                this.world.spawnParticle("flame", d1, d3, d5, 0.0, 0.0, 0.0, 0);
                this.world.playSoundAtEntity((Entity)null, (Entity)this, "mob.ghast.fireball", 0.025f, 0.75f);
            }
            for (int j = 0; j < backupCount; ++j) {
                MobZombie mobZombie = new MobZombie(this.world);
                mobZombie.moveTo(this.x + (double)this.random.nextInt(3) - 1.0, this.y + 0.5, this.z + (double)this.random.nextInt(3) - 1.0, this.random.nextFloat() * 360.0f, this.random.nextFloat() * 360.0f);
                this.world.entityJoinedWorld((Entity)mobZombie);
            }
        }
        super.onLivingUpdate();
    }

    public int getAmbientSoundInterval() {
        return 25;
    }

    public void playLivingSound() {
        if (this.world != null) {
            String s = this.getLivingSound();
            s = this.instrument > 10 ? "bd" : (this.instrument > 9 ? "hat" : (this.instrument > 8 ? "bassattack" : (this.instrument > 7 ? "harp" : (this.instrument > 6 ? "chant" : (this.instrument > 5 ? "drum_steel" : (this.instrument > 4 ? "chip_triangle" : (this.instrument > 3 ? "guitar_electric" : (this.instrument > 2 ? "celesta" : (this.instrument > 1 ? "wood_block" : "snare")))))))));
            if (!this.world.isClientSide) {
                this.world.playSoundAtEntity((Entity)null, (Entity)this, "note." + s, this.getSoundVolume() * 2.0f, (this.random.nextFloat() * 1.7f - this.random.nextFloat()) * 1.7f);
            }
            this.world.spawnParticle("note", this.x, this.y + 1.9, this.z, 0.0, 0.0, 0.0, 1);
        }
    }

    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int blockX = MathHelper.floor((double)this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor((double)this.bb.minY), blockZ = MathHelper.floor((double)this.z)) > 0) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 4.0f)) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }
}

