/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import javax.annotation.Nullable;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class MobPopper
extends MobCreeper {
    int timeSinceIgnited;
    int lastActiveTime;

    public MobPopper(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"popper");
        this.moveSpeed = 1.1f;
        this.scoreValue = 1000;
        this.fireImmune = true;
        this.setHealthRaw(50);
        this.setSize(1.2f, 2.6f);
    }

    public void tick() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.world.isClientSide) {
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0 && !this.world.isClientSide) {
                this.world.playSoundAtEntity((Entity)null, (Entity)this, "mob.creeper.fuse", 1.0f, 1.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 25) {
                this.timeSinceIgnited = 25;
            }
        }
        super.tick();
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (!this.world.isClientSide) {
            int i = this.getCreeperState();
            if (i <= 0 && distance < 3.0f || i > 0 && distance < 4.0f) {
                if (this.timeSinceIgnited == 0 && !this.world.isClientSide) {
                    this.world.playSoundAtEntity((Entity)null, (Entity)this, "mob.creeper.fuse", 1.0f, 1.5f);
                }
                this.setCreeperState(1);
                ++this.timeSinceIgnited;
                if (this.timeSinceIgnited >= 25) {
                    if (this.getPowered()) {
                        this.world.createExplosion((Entity)this, this.x, this.y + (double)(this.bbHeight / 5.0f), this.z, 4.0f);
                    } else {
                        this.world.createExplosion((Entity)this, this.x, this.y + (double)(this.bbHeight / 2.5f), this.z, 2.0f);
                    }
                    this.timeSinceIgnited = 5;
                }
                this.hasAttacked = true;
            } else {
                this.setCreeperState(-1);
                --this.timeSinceIgnited;
                if (this.timeSinceIgnited < 0) {
                    this.timeSinceIgnited = 0;
                }
            }
        }
    }

    public boolean canClimb() {
        return this.horizontalCollision;
    }

    private int getCreeperState() {
        return this.entityData.getByte(16);
    }

    private void setCreeperState(int i) {
        this.entityData.set(16, (Object)((byte)i));
    }

    public boolean canSpawnHere() {
        int z;
        int y;
        int x = MathHelper.floor((double)this.x);
        if (this.world.getBlockId(x, y = MathHelper.floor((double)this.y), z = MathHelper.floor((double)this.z)) != 0) {
            return false;
        }
        Block below = this.world.getBlock(x, y - 1, z);
        if (!BlockTags.NETHER_MOBS_SPAWN.appliesTo((ITaggable)below)) {
            return false;
        }
        int blockLight = this.world.getSavedLightValue(LightLayer.Block, x, y, z);
        if (blockLight > 7) {
            return false;
        }
        return this.world.getDifficulty().canHostileMobsSpawn() && this.world.checkIfAABBIsClear(this.bb) && this.world.getCubes((Entity)this, this.bb).isEmpty() && !this.world.getIsAnyLiquid(this.bb);
    }

    public String getLivingSound() {
        return "deep:mob.popper.pop";
    }
}

