/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;

public class MobShade
extends MobMonster {
    public MobShade(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"shade");
        this.attackStrength = 12;
        this.moveSpeed = 9.0f;
        this.speed = 0.3f;
        this.scoreValue = 900;
        this.setHealthRaw(4);
        this.mobDrops.add(new WeightedRandomLootObject(Items.BONE.getDefaultStack(), 0, 2));
    }

    public void onLivingUpdate() {
        if (this.world.isDaytime()) {
            float f = this.getBrightness(1.0f);
            Weather weather = this.world.getCurrentWeather();
            if (f > 0.5f && this.world.canBlockSeeTheSky(MathHelper.floor((double)this.x), MathHelper.floor((double)this.y), MathHelper.floor((double)this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && weather != null && !weather.isDamp && (this.world.getCurrentWeather() != Weathers.OVERWORLD_FOG || this.world.weatherManager.getWeatherPower() < 0.75f)) {
                this.remainingFireTicks = 300;
            }
        }
        super.onLivingUpdate();
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        float brightness = this.getBrightness(1.0f);
        if (brightness > 0.5f && this.random.nextInt(100) == 0) {
            this.target = null;
        } else if (distance > 1.0f && distance < 8.0f && this.random.nextInt(5) == 0) {
            if (this.onGround) {
                double d = entity.x - this.x;
                double d1 = entity.z - this.z;
                float f2 = MathHelper.sqrt((double)(d * d + d1 * d1));
                this.xd = d / (double)f2 * 0.5 * (double)0.8f + this.xd * 0.2;
                this.zd = d1 / (double)f2 * 0.5 * (double)0.8f + this.zd * 0.2;
                this.yd = 0.4f;
            }
        } else {
            super.attackEntity(entity, distance);
        }
    }

    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int blockX = MathHelper.floor((double)this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor((double)this.bb.minY), blockZ = MathHelper.floor((double)this.z)) > 0) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 6.0f)) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }

    public String getLivingSound() {
        return "deep:mob.shade.whisper";
    }

    protected String getHurtSound() {
        return "deep:mob.shade.hurt";
    }

    protected String getDeathSound() {
        return "deep:mob.shade.death";
    }

    protected float getSoundVolume() {
        return 1.0f;
    }
}

