/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.recipe;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.item.ItemStack;
import silveon22.deep.recipe.RecipeFreezerJsonAdapter;

public class RecipeEntryFreezer
extends RecipeEntryBase<RecipeSymbol, ItemStack, Void>
implements HasJsonAdapter {
    public RecipeEntryFreezer(RecipeSymbol input, ItemStack output) {
        super((Object)input, (Object)output, null);
    }

    public RecipeEntryFreezer() {
    }

    public Void getData() {
        return null;
    }

    public boolean containsData(Void data) {
        return false;
    }

    public boolean matches(ItemStack stack) {
        return ((RecipeSymbol)this.getInput()).matches(stack);
    }

    public boolean matchesQueryIgnoreExceptions(SearchQuery query) {
        try {
            return this.matchesQuery(query);
        }
        catch (IllegalArgumentException | NullPointerException var3) {
            return false;
        }
    }

    public boolean matchesQuery(SearchQuery query) {
        switch (query.mode) {
            case ALL: {
                if (!this.matchesRecipe(query) && !this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
            case RECIPE: {
                if (!this.matchesRecipe(query) || !this.matchesScope(query)) break;
                return true;
            }
            case USAGE: {
                if (!this.matchesUsage(query) || !this.matchesScope(query)) break;
                return true;
            }
        }
        return false;
    }

    private boolean matchesRecipe(SearchQuery query) {
        if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
            if (query.strict && ((ItemStack)this.getOutput()).getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                return true;
            }
            if (!query.strict && ((ItemStack)this.getOutput()).getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase())) {
                return true;
            }
        } else if (query.query.getLeft() == SearchQuery.QueryType.GROUP && !Objects.equals(query.query.getRight(), "")) {
            List groupStacks = new RecipeSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            return groupStacks.contains(this.getOutput());
        }
        return false;
    }

    private boolean matchesUsage(SearchQuery query) {
        for (ItemStack stack : ((RecipeSymbol)this.getInput()).resolve()) {
            if (stack == null) continue;
            if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
                if (query.strict && stack.getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                    return true;
                }
                if (query.strict || !stack.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase())) continue;
                return true;
            }
            if (query.query.getLeft() != SearchQuery.QueryType.GROUP || Objects.equals(query.query.getRight(), "")) continue;
            List groupStacks = new RecipeSymbol((String)query.query.getRight()).resolve();
            if (groupStacks == null) {
                return false;
            }
            return groupStacks.contains(this.getOutput());
        }
        return false;
    }

    private boolean matchesScope(SearchQuery query) {
        if (query.scope.getLeft() == SearchQuery.SearchScope.NONE) {
            return true;
        }
        if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE) {
            RecipeNamespace namespace = (RecipeNamespace)Registries.RECIPES.getItem((String)query.scope.getRight());
            if (namespace == this.parent.getParent()) {
                return true;
            }
        } else if (query.scope.getLeft() == SearchQuery.SearchScope.NAMESPACE_GROUP) {
            RecipeGroup group;
            try {
                group = Registries.RECIPES.getGroupFromKey((String)query.scope.getRight());
            }
            catch (IllegalArgumentException var4) {
                group = null;
            }
            if (group == this.parent) {
                return true;
            }
        }
        return false;
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new RecipeFreezerJsonAdapter();
    }
}

