package silveon22.deep.block.ore;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import silveon22.deep.item.DEEPItems;

public class BlockLogicRhodoniteOre extends BlockLogic {
	public BlockLogicRhodoniteOre(Block block) {
		super(block, Material.stone);
	}

	public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
		switch (dropCause) {
			case SILK_TOUCH:
			case PICK_BLOCK:
				return new ItemStack[]{new ItemStack(this)};
			case EXPLOSION:
			case PROPER_TOOL:
				return new ItemStack[]{new ItemStack((DEEPItems.rhodonite), 2 + world.rand.nextInt(4))};
			default:
				return null;
		}
	}
}
