/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.Guidebook;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.MathHelper;
import silveon22.deep.DEEPRecipes;
import silveon22.deep.Guidebook.RecipePageBaking;
import silveon22.deep.recipe.RecipeEntryBrickOven;

@Environment(value=EnvType.CLIENT)
public class GuidebookSectionBaking
extends SearchableGuidebookSection {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;

    public GuidebookSectionBaking(String translationKey, ItemStack tabIcon, int bgColor, int fgColor) {
        super(translationKey, tabIcon, bgColor, fgColor);
        this.reloadRecipes();
    }

    public List<GuidebookPage> searchPages(SearchQuery query) {
        if (this.filteredPages != null && Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            return (List)this.filteredPages.getRight();
        }
        ArrayList<RecipeEntryBrickOven> filteredRecipes = new ArrayList<RecipeEntryBrickOven>();
        ArrayList<RecipeEntryBrickOven> allRecipes = new ArrayList<RecipeEntryBrickOven>(DEEPRecipes.getAllRecipesOfType(RecipeEntryBrickOven.class));
        allRecipes.removeIf(Objects::isNull);
        for (RecipeEntryBrickOven recipe : allRecipes) {
            if (!recipe.matchesQueryIgnoreExceptions(query)) continue;
            filteredRecipes.add(recipe);
        }
        ArrayList<GuidebookPage> filteredPages = new ArrayList<GuidebookPage>();
        int filteredRecipeSize = filteredRecipes.size();
        int filteredPageCount = MathHelper.ceilInt((int)filteredRecipeSize, (int)3);
        for (int i = 0; i < filteredPageCount; ++i) {
            int j = i * 6;
            ArrayList<RecipeEntryBrickOven> recipes = new ArrayList<RecipeEntryBrickOven>(filteredRecipes.subList(Math.min(j, filteredRecipeSize), Math.min(j + 6, filteredRecipeSize)));
            if (recipes.size() <= 0) continue;
            filteredPages.add((GuidebookPage)new RecipePageBaking((GuidebookSection)this, recipes));
        }
        this.filteredPages = Pair.of((Object)query.rawQuery, filteredPages);
        return filteredPages;
    }

    public void reloadRecipes() {
        this.pages.clear();
        ArrayList<RecipeEntryBrickOven> allRecipes = new ArrayList<RecipeEntryBrickOven>(DEEPRecipes.getAllRecipesOfType(RecipeEntryBrickOven.class));
        allRecipes.removeIf(Objects::isNull);
        int totalRecipes = allRecipes.size();
        int totalPages = MathHelper.ceilInt((int)totalRecipes, (int)6);
        for (int i = 0; i < totalPages; ++i) {
            int j = i * 6;
            ArrayList<RecipeEntryBrickOven> recipes = new ArrayList<RecipeEntryBrickOven>(allRecipes.subList(Math.min(j, totalRecipes), Math.min(j + 6, totalRecipes)));
            this.pages.add((GuidebookPage)new RecipePageBaking((GuidebookSection)this, recipes));
        }
    }

    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    public List<GuidebookSection.Index> getIndices() {
        return null;
    }
}

