/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.Guidebook;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.MathHelper;
import silveon22.deep.DEEPRecipes;
import silveon22.deep.Guidebook.RecipePageFreezing;
import silveon22.deep.recipe.RecipeEntryFreezer;

@Environment(value=EnvType.CLIENT)
public class GuidebookSectionFreezing
extends SearchableGuidebookSection {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;

    public GuidebookSectionFreezing(String translationKey, ItemStack tabIcon, int bgColor, int fgColor) {
        super(translationKey, tabIcon, bgColor, fgColor);
        this.reloadRecipes();
    }

    public List<GuidebookPage> searchPages(SearchQuery query) {
        if (this.filteredPages != null && Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            return (List)this.filteredPages.getRight();
        }
        ArrayList<RecipeEntryFreezer> filteredRecipes = new ArrayList<RecipeEntryFreezer>();
        ArrayList<RecipeEntryFreezer> allRecipes = new ArrayList<RecipeEntryFreezer>(DEEPRecipes.getAllRecipesOfType(RecipeEntryFreezer.class));
        allRecipes.removeIf(Objects::isNull);
        for (RecipeEntryFreezer recipe : allRecipes) {
            if (!recipe.matchesQueryIgnoreExceptions(query)) continue;
            filteredRecipes.add(recipe);
        }
        ArrayList<GuidebookPage> filteredPages = new ArrayList<GuidebookPage>();
        int filteredRecipeSize = filteredRecipes.size();
        int filteredPageCount = MathHelper.ceilInt((int)filteredRecipeSize, (int)3);
        for (int i = 0; i < filteredPageCount; ++i) {
            int j = i * 6;
            ArrayList<RecipeEntryFreezer> recipes = new ArrayList<RecipeEntryFreezer>(filteredRecipes.subList(Math.min(j, filteredRecipeSize), Math.min(j + 6, filteredRecipeSize)));
            if (recipes.size() <= 0) continue;
            filteredPages.add((GuidebookPage)new RecipePageFreezing((GuidebookSection)this, recipes));
        }
        this.filteredPages = Pair.of((Object)query.rawQuery, filteredPages);
        return filteredPages;
    }

    public void reloadRecipes() {
        this.pages.clear();
        ArrayList<RecipeEntryFreezer> allRecipes = new ArrayList<RecipeEntryFreezer>(DEEPRecipes.getAllRecipesOfType(RecipeEntryFreezer.class));
        allRecipes.removeIf(Objects::isNull);
        int totalRecipes = allRecipes.size();
        int totalPages = MathHelper.ceilInt((int)totalRecipes, (int)6);
        for (int i = 0; i < totalPages; ++i) {
            int j = i * 6;
            ArrayList<RecipeEntryFreezer> recipes = new ArrayList<RecipeEntryFreezer>(allRecipes.subList(Math.min(j, totalRecipes), Math.min(j + 6, totalRecipes)));
            this.pages.add((GuidebookPage)new RecipePageFreezing((GuidebookSection)this, recipes));
        }
    }

    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    public List<GuidebookSection.Index> getIndices() {
        return null;
    }
}

