/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mixins;

import java.util.Random;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.generate.feature.WorldFeatureLabyrinth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import silveon22.deep.block.DEEPBlocks;
import silveon22.deep.item.DEEPItems;

@Mixin(value={WorldFeatureLabyrinth.class}, remap=false)
public class LabyrinthGenerationMixin {
    @Shadow
    int wallBlockA;
    @Shadow
    int wallBlockB;
    @Shadow
    int brickBlockA;
    @Shadow
    int brickBlockB;
    @Shadow
    int slabBlock;
    @Shadow
    public ItemStack treasureItem;
    @Shadow
    public WeightedRandomBag<String> spawnerMonsters;
    @Unique
    private boolean isHot;
    @Unique
    private boolean isWet;

    @Inject(method={"place"}, at={@At(value="HEAD")})
    public void generate(World world, Random random, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        Biome biome = world.getBlockBiome(x, y, z);
        if (biome == Biomes.OVERWORLD_DESERT || biome == Biomes.OVERWORLD_OUTBACK) {
            this.isHot = true;
        }
        if (biome == Biomes.OVERWORLD_SWAMPLAND || biome == Biomes.OVERWORLD_SWAMPLAND_MUDDY || biome == Biomes.OVERWORLD_RAINFOREST) {
            this.wallBlockA = Blocks.MUD_BAKED.id();
            this.wallBlockB = DEEPBlocks.packedMudBrick.id();
            this.brickBlockA = Blocks.LOG_OAK.id();
            this.brickBlockB = Blocks.LOG_OAK_MOSSY.id();
            this.slabBlock = Blocks.LEAVES_OAK.id();
            this.isWet = true;
        }
    }

    @Inject(method={"place"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/world/generate/feature/WorldFeatureLabyrinth;canReplace(Lnet/minecraft/core/world/World;III)Z")})
    public void generateTreasure(World world, Random random, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        if (this.isHot) {
            this.spawnerMonsters.addEntry((Object)"Spider", 1.0);
            this.spawnerMonsters.addEntry((Object)"ArmouredZombie", 1.0);
            this.treasureItem = DEEPBlocks.statueBastBottom.getDefaultStack();
        }
        if (this.isWet) {
            this.spawnerMonsters.addEntry((Object)"Creeper", 1.0);
            this.spawnerMonsters.addEntry((Object)"ArmouredZombie", 1.0);
            this.treasureItem = DEEPItems.divingHelmet.getDefaultStack();
        }
    }
}

