/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import silveon22.deep.item.DEEPItems;

public class MobCaveCreeper
extends MobCreeper {
    public MobCaveCreeper(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"cave_creeper");
        this.moveSpeed = 1.2f;
        this.scoreValue = 1000;
        this.setHealthRaw(34);
        this.setSize(0.6f, 1.6f);
        this.mobDrops.add(new WeightedRandomLootObject(DEEPItems.niter.getDefaultStack(), 0, 3));
    }

    public boolean canClimb() {
        return this.horizontalCollision;
    }

    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int blockX = MathHelper.floor((double)this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor((double)this.bb.minY), blockZ = MathHelper.floor((double)this.z)) > 0) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 3.0f)) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }
}

