/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import silveon22.deep.item.DEEPItems;

public class MobElderSkeleton
extends MobSkeleton {
    private static final ItemStack neoDefaultHeldItem = new ItemStack(DEEPItems.toolBowSteel, 1);

    public MobElderSkeleton(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"elder_skeleton");
        this.moveSpeed = 2.0f;
        this.scoreValue = 1000;
        this.setHealthRaw(34);
        this.mobDrops.add(new WeightedRandomLootObject(Items.AMMO_ARROW.getDefaultStack(), 2, 5));
        this.mobDrops.add(new WeightedRandomLootObject(Items.BONE.getDefaultStack(), 0, 2));
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (distance < 10.0f) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    ProjectileArrow arrow = new ProjectileArrow(this.world, (Mob)this, false, 1);
                    double d2 = entity.y + (double)entity.getHeadHeight() - 0.2 - arrow.y;
                    float f1 = MathHelper.sqrt((double)(d * d + d1 * d1)) * 0.2f;
                    this.world.playSoundAtEntity((Entity)null, (Entity)this, "random.bow", 1.0f, 1.6f / (this.random.nextFloat() * 0.4f + 0.8f));
                    arrow.setHeading(d, d2 + (double)f1, d1, 0.6f, 3.0f);
                    this.world.entityJoinedWorld((Entity)arrow);
                }
                this.attackTime = 20;
            }
            this.yRot = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
    }

    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int blockX = MathHelper.floor((double)this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor((double)this.bb.minY), blockZ = MathHelper.floor((double)this.z)) > 0) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 4.0f)) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }

    public String getLivingSound() {
        return "deep:mob.elder.skeleton.say";
    }

    protected String getHurtSound() {
        return "deep:mob.elder.skeleton.hurt";
    }

    protected String getDeathSound() {
        return "deep:mob.elder.skeleton.death";
    }

    public ItemStack getHeldItem() {
        return neoDefaultHeldItem;
    }
}

