/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import javax.annotation.Nullable;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class MobPistonZombie
extends MobZombie {
    public MobPistonZombie(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"piston_zombie");
        this.moveSpeed = 0.4f;
        this.attackStrength = 5;
        this.setHealthRaw(25);
        this.scoreValue = 500;
        this.mobDrops.add(new WeightedRandomLootObject(Items.CLOTH.getDefaultStack(), 0, 2));
    }

    public void knockBack(Entity entity, int i, double d, double d1) {
        float f = MathHelper.sqrt((double)(d * d + d1 * d1));
        float f1 = -0.6f;
        this.xd /= 1.0;
        this.yd = 0.5;
        this.zd /= 1.0;
        this.xd -= d / (double)f * (double)f1;
        this.yd += 1.0;
        this.zd -= d1 / (double)f * (double)f1;
        this.world.playSoundAtEntity((Entity)null, (Entity)this, "tile.piston.out", 1.0f, (this.random.nextFloat() * 1.2f - this.random.nextFloat()) * 1.2f);
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (distance > 2.0f && distance < 16.0f && this.y < entity.y - 3.0 && this.random.nextInt(15) == 0) {
            if (this.onGround) {
                double d = entity.x - this.x;
                double d1 = entity.z - this.z;
                float f2 = MathHelper.sqrt((double)(d * d + d1 * d1));
                this.xd = d / (double)f2 * 0.5 * (double)0.8f + this.xd * 0.2;
                this.zd = d1 / (double)f2 * 0.5 * (double)0.8f + this.zd * 0.2;
                this.yd += 1.0 + (double)this.random.nextFloat();
                this.world.playSoundAtEntity((Entity)null, (Entity)this, "tile.piston.out", 1.0f, (this.random.nextFloat() * 1.2f - this.random.nextFloat()) * 1.2f);
            }
        } else {
            super.attackEntity(entity, distance);
        }
    }

    protected void jump() {
        if (!this.noPhysics) {
            this.xd += this.xd;
            this.yd += 1.0;
            this.zd += this.zd;
            this.world.playSoundAtEntity((Entity)null, (Entity)this, "tile.piston.out", 1.0f, (this.random.nextFloat() * 1.2f - this.random.nextFloat()) * 1.2f);
        }
    }

    protected void causeFallDamage(float distance) {
    }

    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        int blockX = MathHelper.floor((double)this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor((double)this.bb.minY), blockZ = MathHelper.floor((double)this.z)) > 0) {
            return false;
        }
        if (this.y > (double)((float)rangeY / 1.8f)) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }
}

