/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.mob;

import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class MobRedSlime
extends MobSlime {
    private final boolean hasSlimeSplit;
    private int jumpDelay = 0;

    public MobRedSlime(World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"red_slime");
        this.heightOffset = 0.0f;
        this.hasSlimeSplit = false;
        this.jumpDelay = 10;
        this.scoreValue = 150;
        this.mobDrops.add(new WeightedRandomLootObject(Items.SLIMEBALL.getDefaultStack(), 0, 2));
    }

    public MobRedSlime(World world, boolean isSplit) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"deep", (String)"red_slime");
        this.heightOffset = 0.0f;
        this.hasSlimeSplit = isSplit;
        this.scoreValue = 150;
        this.mobDrops.add(new WeightedRandomLootObject(Items.SLIMEBALL.getDefaultStack(), 0, 2));
    }

    protected void updateAI() {
        boolean targetPlayer;
        this.tryToDespawn();
        Player entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 16.0);
        boolean bl = targetPlayer = entityplayer != null && entityplayer.getGamemode().areMobsHostile();
        if (entityplayer != null && targetPlayer) {
            this.lookAt((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.onGround && this.jumpDelay-- <= 0) {
            if (!targetPlayer) {
                float rotation = (this.world.rand.nextFloat() - 0.5f) * 90.0f;
                this.yRot += rotation;
            }
            this.jumpDelay = this.random.nextInt(10) + 5;
            if (entityplayer != null) {
                this.jumpDelay /= 6;
            }
            this.isJumping = true;
            if (this.getSlimeSize() > 1) {
                this.world.playSoundAtEntity((Entity)null, (Entity)this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.squish = 1.8f;
            this.moveStrafing = 2.0f - this.random.nextFloat() * 2.0f;
            this.moveForward = (float)this.getSlimeSize() * 3.0f;
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    public void remove() {
        int size = this.getSlimeSize();
        if (!this.world.isClientSide && size > 1 && this.getHealth() <= 0) {
            int splitCount = this.world.rand.nextInt(4) + 1;
            for (int j = 0; j < splitCount; ++j) {
                float f = ((float)(j % 2) - 0.5f) * (float)size / 2.0f;
                float f1 = ((float)(j / 2) - 0.5f) * (float)size / 2.0f;
                MobRedSlime mobRedSlime = new MobRedSlime(this.world, true);
                mobRedSlime.setSlimeSize(size / 2);
                mobRedSlime.moveTo(this.x + (double)f, this.y + 0.5, this.z + (double)f1, this.random.nextFloat() * 360.0f, 0.0f);
                this.world.entityJoinedWorld((Entity)mobRedSlime);
            }
        }
        this.removed = true;
    }

    protected String getHurtSound() {
        return "mob.slime";
    }

    protected String getDeathSound() {
        return "mob.slime";
    }

    public boolean canSpawnHere() {
        Chunk chunk = this.world.getChunkFromBlockCoords(MathHelper.floor((double)this.x), MathHelper.floor((double)this.z));
        if (this.y > 32.0) {
            return false;
        }
        if (chunk.getChunkRandom(987234911L).nextInt(10) != 0) {
            return false;
        }
        return !this.world.getDifficulty().canHostileMobsSpawn() ? false : super.canSpawnHere();
    }

    protected float getSoundVolume() {
        return 0.6f;
    }
}

