/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.worldfeatures;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureGeode
extends WorldFeature {
    public int oreID;
    public int blockID = Blocks.BASALT.id();
    public int blockID2 = Blocks.MARBLE.id();
    public int oreChance;
    public int radius = 4;

    public WorldFeatureGeode(int oreID, int blockID, int blockId2, int oreChance) {
        this.oreID = oreID;
        this.blockID = blockID;
        this.blockID2 = blockId2;
        this.oreChance = oreChance;
    }

    public WorldFeatureGeode(int oreId, int blockId, int blockId2, int oreChance, int radius) {
        this.oreID = oreId;
        this.blockID = blockId;
        this.blockID2 = blockId2;
        this.oreChance = oreChance;
        this.radius = radius;
    }

    public boolean place(World world, Random random, int i, int j, int k) {
        int z;
        int y;
        int x;
        int oreBlocks = 0;
        int radius1 = this.radius + 2;
        int radius2 = this.radius + 3;
        for (x = -radius2 + 1; x <= radius2; ++x) {
            for (y = -radius2; y <= radius2; ++y) {
                for (z = -radius2; z <= radius2; ++z) {
                    if (!this.isPointInsideSphere(x, y, z, radius2) || world.getBlock(x + i, y + j - 8, z + k) == Blocks.BEDROCK) continue;
                    world.setBlockAndMetadataWithNotify(x + i, y + j - 8, z + k, 0, 0);
                }
            }
        }
        for (x = -radius1 + 1; x <= radius1; ++x) {
            for (y = -radius1; y <= radius1; ++y) {
                for (z = -radius1; z <= radius1; ++z) {
                    if (!this.isPointInsideSphere(x, y, z, radius1) || world.getBlock(x + i, y + j - 8, z + k) == Blocks.BEDROCK) continue;
                    world.setBlockAndMetadataWithNotify(x + i, y + j - 8, z + k, this.blockID2, 0);
                }
            }
        }
        for (x = -this.radius; x <= this.radius; ++x) {
            for (y = -this.radius; y <= this.radius; ++y) {
                for (z = -this.radius; z <= this.radius; ++z) {
                    if (!this.isPointInsideSphere(x, y, z, this.radius) || world.getBlock(x + i, y + j - 8, z + k) == Blocks.BEDROCK) continue;
                    if (this.oreID != 0 && random.nextInt(100) < this.oreChance) {
                        world.setBlockAndMetadataWithNotify(x + i, y + j - 8, z + k, this.oreID, 0);
                        ++oreBlocks;
                        continue;
                    }
                    world.setBlockAndMetadataWithNotify(x + i, y + j - 8, z + k, this.blockID, 0);
                }
            }
        }
        return true;
    }

    public boolean isPointInsideSphere(int x, int y, int z, double radius) {
        return (double)(x * x + y * y + z * z) < radius * radius;
    }
}

