package silveon22.deep;

import net.fabricmc.api.ModInitializer;
import net.minecraft.client.gui.guidebook.mobs.MobInfoRegistry;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import silveon22.deep.block.DEEPBlocks;
import silveon22.deep.item.DEEPItems;
import silveon22.deep.mob.*;
import turniplabs.halplibe.helper.EntityHelper;
import turniplabs.halplibe.util.GameStartEntrypoint;
import turniplabs.halplibe.util.RecipeEntrypoint;


public class Deep implements ModInitializer, RecipeEntrypoint, GameStartEntrypoint {
	public static final String MOD_ID = "deep";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	@Override
	public void onInitialize() {
		DEEPBlocks.initBlocks();
		EntityHelper.createEntity(MobElderSkeleton.class, NamespaceID.getPermanent(MOD_ID, "elder_skeleton"), "entity.deep.elder.skeleton");
		EntityHelper.createEntity(MobCaveCreeper.class, NamespaceID.getPermanent(MOD_ID, "cave_creeper"), "entity.deep.cave.creeper");
		EntityHelper.createEntity(MobWerewolf.class, NamespaceID.getPermanent(MOD_ID, "werewolf"), "entity.deep.werewolf");
		EntityHelper.createEntity(MobJellyfish.class, NamespaceID.getPermanent(MOD_ID, "jellyfish"), "entity.deep.jellyfish");
		EntityHelper.createEntity(MobShade.class, NamespaceID.getPermanent(MOD_ID, "shade"), "entity.deep.shade");
		EntityHelper.createEntity(MobRedSlime.class, NamespaceID.getPermanent(MOD_ID, "red_slime"), "entity.deep.slime.red");
		EntityHelper.createEntity(MobWaterSlime.class, NamespaceID.getPermanent(MOD_ID, "water_slime"), "entity.deep.slime.water");
		EntityHelper.createEntity(MobVolatileSlime.class, NamespaceID.getPermanent(MOD_ID, "volatile_slime"), "entity.deep.slime.volatile");
		LOGGER.info("DEEP initialized.");
	}

	@Override
	public void onRecipesReady() {

	}

	@Override
	public void initNamespaces() {

	}

	@Override
	public void beforeGameStart() {

	}

	@Override
	public void afterGameStart() {
		MobInfoRegistry.register(MobElderSkeleton.class, "guidebook.section.deep.mob.elder.skeleton.name", "guidebook.section.deep.mob.elder.skeleton.desc", 34, 1000, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Items.BONE), 0.66F, 1, 2), new MobInfoRegistry.MobDrop(new ItemStack(Items.AMMO_ARROW), 0.66F, 1, 5)});
		MobInfoRegistry.register(MobCaveCreeper.class, "guidebook.section.deep.mob.cave.creeper.name", "guidebook.section.deep.mob.cave.creeper.desc", 34, 1000, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Items.SULPHUR), 0.66F, 1, 2), new MobInfoRegistry.MobDrop(new ItemStack(DEEPItems.niter), 0.66F, 1, 3)});
		MobInfoRegistry.register(MobWerewolf.class, "guidebook.section.deep.mob.werewolf.name", "guidebook.section.deep.mob.werewolf.desc", 12, 300, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Items.BONE), 0.66F, 1, 2), new MobInfoRegistry.MobDrop(new ItemStack(Items.CLOTH), 0.66F, 1, 2)});
		MobInfoRegistry.register(MobJellyfish.class, "guidebook.section.deep.mob.jellyfish.name", "guidebook.section.deep.mob.jellyfish.desc", 2, 25, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(DEEPItems.gel), 0.66F, 1, 2)});
		MobInfoRegistry.register(MobShade.class, "guidebook.section.deep.mob.shade.name", "guidebook.section.deep.mob.shade.desc", 4, 900, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Items.BONE), 0.66F, 1, 2)});
		MobInfoRegistry.register(MobRedSlime.class, "guidebook.section.deep.mob.slime.red.name", "guidebook.section.deep.mob.slime.red.desc", 0, 150, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Items.SLIMEBALL), 0.66F, 1, 2)});
		MobInfoRegistry.register(MobWaterSlime.class, "guidebook.section.deep.mob.slime.water.name", "guidebook.section.deep.mob.slime.water.desc", 0, 125, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Items.SLIMEBALL), 0.66F, 1, 2)});
		MobInfoRegistry.register(MobVolatileSlime.class, "guidebook.section.deep.mob.slime.volatile.name", "guidebook.section.deep.mob.slime.volatile.desc", 0, 175, new MobInfoRegistry.MobDrop[]{new MobInfoRegistry.MobDrop(new ItemStack(Items.SLIMEBALL), 0.66F, 1, 2), new MobInfoRegistry.MobDrop(new ItemStack(Items.SULPHUR), 0.66F, 1, 2)});
	}
}
