package silveon22.deep.mob;

import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import silveon22.deep.item.DEEPItems;

import javax.annotation.Nullable;

public class MobCaveCreeper extends MobCreeper {
	public MobCaveCreeper(@Nullable World world) {
		super(world);
		this.textureIdentifier = NamespaceID.getPermanent("deep", "cave_creeper");
		this.moveSpeed = 1.2F;
		this.scoreValue = 1000;
		this.setHealthRaw(34);
		this.setSize(0.6F, 1.6F);
		this.mobDrops.add(new WeightedRandomLootObject(DEEPItems.niter.getDefaultStack(), 0, 3));
	}
	public boolean canClimb() {
		return this.horizontalCollision;
	}
}
