/*
 * Decompiled with CFR 0.152.
 */
package silveon22.deep.block.misc;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class BlockLogicExplosiveMushroom
extends BlockLogicFlower {
    public BlockLogicExplosiveMushroom(Block<?> block) {
        super(block);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        block.setTicking(true);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        int metaData = world.getBlockMetadata(x, y, z);
        if (entity instanceof Player) {
            if (entity.isSneaking()) {
                entity.yd = 0.0;
                return;
            }
            if (entity.tickCount % 2 == 0) {
                entity.hurt((Entity)null, 5, DamageType.BLAST);
                entity.fireHurt();
                ((Mob)entity).spawnExplosionParticle();
                world.setBlockWithNotify(x, y, z, 0);
                world.playSoundEffect((Entity)null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "random.explode", 1.0f, 0.7f);
            }
        }
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        int z2;
        int x2;
        int z1;
        int randY;
        int x1;
        if (rand.nextInt(25) == 0 && world.isAirBlock(x1 = x + rand.nextInt(3) - 1, randY = y + rand.nextInt(2) - rand.nextInt(2), z1 = z + rand.nextInt(3) - 1) && this.canBlockStay(world, x1, randY, z1) && world.isAirBlock(x2 = x + rand.nextInt(3) - 1, randY, z2 = z + rand.nextInt(3) - 1) && this.canBlockStay(world, x2, randY, z2)) {
            world.setBlockWithNotify(x2, randY, z2, this.block.id());
        }
    }

    protected boolean mayPlaceOn(int blockId) {
        return Blocks.solid[blockId];
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        if (y >= 0 && y < world.getHeightBlocks()) {
            return world.getFullBlockLightValue(x, y, z) < 13 && this.mayPlaceOn(world.getBlockId(x, y - 1, z));
        }
        return false;
    }

    public boolean onBonemealUsed(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Random rand = world.rand;
        if (!world.isClientSide && this.canBeBonemealed) {
            if (player == null || player.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
            block0: for (int j1 = 0; j1 < 32; ++j1) {
                int _x = blockX;
                int _y = blockY;
                int _z = blockZ;
                for (int j2 = 0; j2 < j1 / 16; ++j2) {
                    if (world.getFullBlockLightValue(_x += rand.nextInt(3) - 1, _y += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, _z += rand.nextInt(3) - 1) >= 13 || !this.mayPlaceOn(world.getBlockId(_x, _y - 1, _z))) continue block0;
                }
                if (world.getBlockId(_x, _y, _z) != 0 || !((double)rand.nextFloat() > 0.85)) continue;
                world.setBlockWithNotify(_x, _y, _z, this.block.id());
            }
            return true;
        }
        return this.canBeBonemealed;
    }
}

