/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="arthritis", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    static final ModConfigSpec clientSpec;
    static final ModConfigSpec commonSpec;
    public static final Client CLIENT;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Config.configure();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Config.configure();
    }

    private static void configure() {
    }

    public static String createTranslation(String name) {
        return "arthritis.config." + name;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue disableHardBlockWarning;
        public final ModConfigSpec.BooleanValue renderCustomHearts;
        public final ModConfigSpec.BooleanValue enableV1;

        Client(ModConfigSpec.Builder builder) {
            this.disableHardBlockWarning = builder.comment("Disable the text warning when breaking a hard block").translation(Config.createTranslation("disable_hard_block_warning")).define("disableHardBlockWarning", false);
            this.renderCustomHearts = builder.comment("Decides whether the mod should render custom hearts").translation(Config.createTranslation("render_custom_hearts")).define("renderCustomHearts", true);
            this.enableV1 = builder.comment("Only works on redirectable projectile...").translation(Config.createTranslation("enable_feedbacker")).define("enableFeedbacker", false);
        }
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<Double> breakingDamage;
        public final ModConfigSpec.ConfigValue<Integer> damageCooldown;
        public final ModConfigSpec.ConfigValue<Double> minimumHardness;
        public final ModConfigSpec.ConfigValue<Boolean> disableFoodPoisoning;
        public final ModConfigSpec.ConfigValue<Double> foodPoisonProbability;
        public final ModConfigSpec.ConfigValue<Integer> foodPoisonAmplifier;
        public final ModConfigSpec.BooleanValue disableBleed;
        public final ModConfigSpec.BooleanValue disableFracture;
        public final ModConfigSpec.BooleanValue disableCripple;
        public final ModConfigSpec.BooleanValue enableMorale;

        Common(ModConfigSpec.Builder builder) {
            this.damageCooldown = builder.comment("The cooldown (in ticks) before the player start taking another damage from breaking a hard block\n(Does not ignore damage invulnerability)\nNote: The current system utilize the players alive time.\nWhich mean the longer the value, it will not take a full time of what it define.").translation(Config.createTranslation("cooldown")).define("damageCooldown", (Object)5);
            this.breakingDamage = builder.comment("The damage the player will take").translation(Config.createTranslation("hand_breaking_damage")).define("breakingDamage", (Object)2.5);
            this.minimumHardness = builder.comment("The minimum hardness of the block before making the player take damage").translation(Config.createTranslation("minimum_hardness")).define("minimumHardness", (Object)0.7);
            this.disableFoodPoisoning = builder.comment("Disable food poisoning").translation(Config.createTranslation("disable_poisoning")).define("disableFoodPoisoning", false);
            this.foodPoisonProbability = builder.comment("The probability of the items that will give poison\nWill not apply to foods with existing poison effect and not in c:item/foods/food_poisoning").translation(Config.createTranslation("poison_probability")).defineInRange("foodPoisonProbability", 0.75, 0.0, 1.0);
            this.foodPoisonAmplifier = builder.comment("The lethality of the poison").translation(Config.createTranslation("poison_amplifier")).defineInRange("foodPoisonAmplifier", 0, 0, 255);
            this.disableBleed = builder.comment("Disable bleed to be inflicted").translation(Config.createTranslation("disable_bleed")).define("disableBleed", false);
            this.disableCripple = builder.comment("Disable cripple (debuff for legs) to be inflicted").translation(Config.createTranslation("disable_cripple")).define("disableCripple", false);
            this.disableFracture = builder.comment("Disable fracture (debuff for hand) to be inflicted").translation(Config.createTranslation("disable_fracture")).define("disableFracture", false);
            this.enableMorale = builder.comment("Enable Morale, or in other words, depression.").translation(Config.createTranslation("enable_morale")).define("enableMorale", false);
        }
    }
}

