/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.common;

import com.proststuff.arthritis.Arthritis;
import com.proststuff.arthritis.Config;
import com.proststuff.arthritis.common.datagen.ModItemTags;
import com.proststuff.arthritis.common.registry.ModAttributes;
import com.proststuff.arthritis.common.registry.ModDamageTypes;
import com.proststuff.arthritis.common.registry.ModEffects;
import com.proststuff.arthritis.common.registry.ModEnchantments;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="arthritis")
public class CommonEvents {
    public static final String MARKED = Arthritis.id(Arthritis.id("marked"));
    public static final String CRIPPLED = Arthritis.id(Arthritis.id("crippled"));

    @SubscribeEvent
    public static void itemAttributeModifier(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        float bleedChance = 0.0f;
        float fractureChance = 0.0f;
        if (!stack.is(Tags.Items.TOOLS)) {
            return;
        }
        if (stack.is(ModItemTags.CAUSE_BLEED)) {
            bleedChance = 0.1f;
            if (stack.is(ItemTags.SWORDS) || stack.is(ItemTags.AXES)) {
                bleedChance = 0.25f;
            }
        }
        if (stack.is(ModItemTags.CAUSE_FRACTURE)) {
            fractureChance = 0.05f;
            if (stack.is(ItemTags.AXES)) {
                fractureChance = 0.25f;
            }
            if (stack.is(ItemTags.SHOVELS)) {
                fractureChance = 0.3f;
            }
            if (stack.is(Tags.Items.TOOLS_MACE)) {
                fractureChance = 0.5f;
            }
        }
        if (bleedChance > 0.0f) {
            event.addModifier(ModAttributes.BLEED_CHANCE, new AttributeModifier(Arthritis.id("bleed_chance"), (double)bleedChance, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        if (fractureChance > 0.0f) {
            event.addModifier(ModAttributes.FRACTURE_CHANCE, new AttributeModifier(Arthritis.id("fracture_chance"), (double)fractureChance, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
    }

    @SubscribeEvent
    public static void livingHealed(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        float amount = event.getAmount();
        MobEffectInstance afterburn = entity.getEffect(ModEffects.AFTERBURN);
        if (afterburn != null) {
            float currentHealth = entity.getHealth();
            float maxHealth = entity.getMaxHealth();
            float effectMaxHealth = (float)Math.clamp((double)(maxHealth - (float)(afterburn.getAmplifier() + 1) / 2.0f), (double)maxHealth * 0.1, (double)maxHealth);
            float newAmount = Math.clamp(currentHealth + amount, currentHealth, effectMaxHealth) - currentHealth;
            event.setAmount(newAmount);
        }
    }

    @SubscribeEvent
    public static void livingDamaged(LivingDamageEvent.Pre event) {
        int effectTime;
        int hardSwingLevel;
        int sharpnessLevel;
        Entity entity;
        DamageSource damageSource = event.getSource();
        LivingEntity victim = event.getEntity();
        if (damageSource.is(DamageTypeTags.IS_FIRE)) {
            ModEffects.addOrStackMobEffect(ModEffects.AFTERBURN, victim, 400);
        }
        if (!((entity = damageSource.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        Level level = victim.level();
        RegistryAccess registryAccess = level.registryAccess();
        RandomSource random = level.getRandom();
        Registry registry = registryAccess.registryOrThrow(Registries.ENCHANTMENT);
        AttributeInstance bleed_chance = attacker.getAttribute(ModAttributes.BLEED_CHANCE);
        double maxBleedChance = bleed_chance != null ? bleed_chance.getValue() : ((Attribute)ModAttributes.BLEED_CHANCE.value()).getDefaultValue();
        double maxFractureChance = bleed_chance != null ? bleed_chance.getValue() : ((Attribute)ModAttributes.FRACTURE_CHANCE.value()).getDefaultValue();
        if (damageSource.getWeaponItem() != null) {
            sharpnessLevel = EnchantmentHelper.getTagEnchantmentLevel((Holder)registry.getHolderOrThrow(Enchantments.SHARPNESS), (ItemStack)damageSource.getWeaponItem());
            hardSwingLevel = EnchantmentHelper.getTagEnchantmentLevel((Holder)registry.getHolderOrThrow(ModEnchantments.HARD_SWING), (ItemStack)damageSource.getWeaponItem());
        } else {
            sharpnessLevel = 0;
            hardSwingLevel = 0;
        }
        int reduction = (int)Math.floor(Objects.requireNonNull(victim.getAttribute(Attributes.ARMOR_TOUGHNESS)).getValue() + Objects.requireNonNull(victim.getAttribute(Attributes.ARMOR)).getValue());
        Arthritis.LOGGER.info(String.valueOf(reduction));
        if ((double)random.nextFloat() <= maxBleedChance + (double)sharpnessLevel / 10.0) {
            effectTime = 200 + 20 * (1 + sharpnessLevel);
            ModEffects.applyBleed(victim, effectTime);
        }
        if ((double)random.nextFloat() <= maxFractureChance + (double)hardSwingLevel / 10.0) {
            effectTime = 200 + 20 * (1 + hardSwingLevel);
            ModEffects.applyFractureOrCripple(victim, effectTime);
        }
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        if (player.isCreative()) {
            return;
        }
        ItemStack item = player.getMainHandItem();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        PlayerInteractEvent.LeftClickBlock.Action action = event.getAction();
        boolean hasTag = player.getTags().contains(MARKED);
        boolean clientSided = level.isClientSide();
        float hardness = state.getDestroySpeed((BlockGetter)level, pos);
        if (action == PlayerInteractEvent.LeftClickBlock.Action.START && !item.is(Tags.Items.TOOLS)) {
            if (clientSided) {
                if (hardness < 0.0f) {
                    player.displayClientMessage((Component)Component.translatable((String)"arthritis.message.impossible_to_break"), true);
                } else if ((double)hardness > (Double)Config.COMMON.minimumHardness.get()) {
                    player.displayClientMessage((Component)Component.translatable((String)"arthritis.message.hard_block"), true);
                }
            } else if (!hasTag && (double)hardness > (Double)Config.COMMON.minimumHardness.get()) {
                player.addTag(MARKED);
            }
        } else if (hasTag && !clientSided) {
            player.removeTag(MARKED);
        }
    }

    @SubscribeEvent
    public static void playerTicked(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.getHealth() <= 0.0f) {
            return;
        }
        Level level = player.level();
        Integer cooldown = (Integer)Config.COMMON.damageCooldown.get();
        float damage = ((Double)Config.COMMON.breakingDamage.get()).floatValue();
        Set tags = player.getTags();
        if (level.isClientSide()) {
            boolean hasCrippledTag = tags.contains(CRIPPLED);
            if (player.getEffect(ModEffects.CRIPPLE) != null) {
                if (!hasCrippledTag) {
                    player.addTag(CRIPPLED);
                }
            } else if (hasCrippledTag) {
                player.removeTag(CRIPPLED);
            }
        } else if (tags.contains(MARKED) && player.tickCount % cooldown == 0) {
            player.hurt(ModDamageTypes.hardPunch(level), damage);
            RandomSource random = level.getRandom();
            if (random.nextFloat() <= 0.05f) {
                player.addEffect(new MobEffectInstance(ModEffects.FRACTURE, 200));
            }
        }
    }

    @SubscribeEvent
    public static void playerRespawned(PlayerEvent.PlayerRespawnEvent event) {
        boolean hasTag;
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && (hasTag = player.getTags().contains(MARKED))) {
            player.removeTag(MARKED);
        }
    }

    @SubscribeEvent
    public static void loadFromFile(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        boolean hasTag = player.getTags().contains(MARKED);
        if (hasTag) {
            player.removeTag(MARKED);
        }
    }

    @SubscribeEvent
    public static void gameModeChanged(PlayerEvent.PlayerChangeGameModeEvent event) {
        boolean hasTag;
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && (hasTag = player.getTags().contains(MARKED))) {
            player.removeTag(MARKED);
        }
    }

    @SubscribeEvent
    public static void entityFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        float distance = event.getDistance();
        float damageMultiplier = event.getDamageMultiplier();
        if (distance >= 8.0f) {
            living.addEffect(new MobEffectInstance(ModEffects.CRIPPLE, (int)Math.floor(distance * 20.0f * damageMultiplier)));
        }
    }

    @SubscribeEvent
    public static void entityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (!creeper.isIgnited()) {
                if (!creeper.isPowered() && entity.isOnFire()) {
                    creeper.ignite();
                }
            } else {
                creeper.removeEffect(ModEffects.BLEED);
            }
        }
    }
}

