/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.common.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class FirestarterItem
extends Item {
    public FirestarterItem() {
        super(new Item.Properties().durability(32));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (!level.isClientSide()) {
            player.startUsingItem(usedHand);
        }
        return super.use(level, player, usedHand);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        BlockHitResult hitResult;
        if (level.isClientSide() || !(livingEntity instanceof Player)) {
            return stack;
        }
        Player player = (Player)livingEntity;
        RandomSource random = level.getRandom();
        if ((double)random.nextFloat() <= 0.25 && (hitResult = FirestarterItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)).getType() == HitResult.Type.BLOCK) {
            UseOnContext context = new UseOnContext(level, player, player.getUsedItemHand(), stack, hitResult);
            BlockPos blockPos1 = context.getClickedPos();
            BlockState blockState = level.getBlockState(blockPos1);
            BlockState blockState1 = blockState.getToolModifiedState(context, ItemAbilities.FIRESTARTER_LIGHT, false);
            if (blockState1 == null) {
                BlockPos blockPos2 = blockPos1.relative(context.getClickedFace());
                if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)blockPos2, (Direction)context.getHorizontalDirection())) {
                    level.playSound(player, blockPos2, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                    BlockState blockState2 = BaseFireBlock.getState((BlockGetter)level, (BlockPos)blockPos2);
                    level.setBlock(blockPos2, blockState2, 11);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockPos2);
                    ItemStack itemstack = context.getItemInHand();
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockPos2, itemstack);
                        itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                    }
                }
            } else {
                level.playSound(player, blockPos1, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                level.setBlock(blockPos1, blockState1, 11);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos1);
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
        }
        return stack;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 48;
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_FLINT_ACTIONS.contains(itemAbility);
    }
}

