/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.common.registry;

import com.proststuff.arthritis.Config;
import com.proststuff.arthritis.common.datagen.ModEntityTypeTags;
import com.proststuff.arthritis.common.effect.Afterburn;
import com.proststuff.arthritis.common.effect.Bandaged;
import com.proststuff.arthritis.common.effect.Bleed;
import com.proststuff.arthritis.common.effect.Cripple;
import com.proststuff.arthritis.common.effect.Fracture;
import com.proststuff.arthritis.common.effect.Splinted;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEffects {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"arthritis");
    public static final DeferredHolder<MobEffect, MobEffect> AFTERBURN = MOB_EFFECTS.register("afterburn", Afterburn::new);
    public static final DeferredHolder<MobEffect, MobEffect> BLEED = MOB_EFFECTS.register("bleed", Bleed::new);
    public static final DeferredHolder<MobEffect, MobEffect> CRIPPLE = MOB_EFFECTS.register("cripple", Cripple::new);
    public static final DeferredHolder<MobEffect, MobEffect> FRACTURE = MOB_EFFECTS.register("fracture", Fracture::new);
    public static final DeferredHolder<MobEffect, MobEffect> BANDAGED = MOB_EFFECTS.register("bandaged", Bandaged::new);
    public static final DeferredHolder<MobEffect, MobEffect> SPLINTED = MOB_EFFECTS.register("splinted", Splinted::new);

    public static void init(IEventBus eventBus) {
        MOB_EFFECTS.register(eventBus);
    }

    public static void applyBleed(LivingEntity entity, int time) {
        if (entity.getType().is(ModEntityTypeTags.BLEED_IMMUNE) || Config.COMMON.disableBleed.getAsBoolean()) {
            return;
        }
        ModEffects.addOrStackMobEffect(BLEED, entity, time);
    }

    public static void applyFractureOrCripple(LivingEntity entity, int time) {
        Level level = entity.level();
        RandomSource random = level.getRandom();
        if (!Config.COMMON.disableCripple.getAsBoolean() && (double)random.nextFloat() <= 0.5 && !entity.getType().is(ModEntityTypeTags.CRIPPLE_IMMUNE)) {
            MobEffectInstance cripple = new MobEffectInstance(CRIPPLE, time, 0, false, false, true);
            entity.addEffect(cripple);
        }
        if (!Config.COMMON.disableFracture.getAsBoolean() && (double)random.nextFloat() <= 0.5 && !entity.getType().is(ModEntityTypeTags.FRACTURE_IMMUNE)) {
            MobEffectInstance fracture = new MobEffectInstance(FRACTURE, time, 0, false, false, true);
            entity.addEffect(fracture);
        }
    }

    public static void addOrStackMobEffect(Holder<MobEffect> effect, LivingEntity entity, int effectTime) {
        int amplifier;
        int duration;
        MobEffectInstance effectInstance = entity.getEffect(effect);
        if (effectInstance != null) {
            int currentDuration = effectInstance.getDuration();
            duration = Math.max(currentDuration, effectTime);
            amplifier = effectInstance.getAmplifier();
        } else {
            amplifier = -1;
            duration = effectTime;
        }
        entity.removeEffect(effect);
        MobEffectInstance newEffectInstance = new MobEffectInstance(effect, duration, amplifier + 1, false, false, true);
        entity.addEffect(newEffectInstance);
    }

    public static void reduceMobEffect(Holder<MobEffect> effect, LivingEntity entity, int reducedBy) {
        MobEffectInstance effectInstance = entity.getEffect(effect);
        if (effectInstance != null) {
            int amp = effectInstance.getAmplifier();
            int duration = effectInstance.getDuration();
            entity.removeEffect(effect);
            if (amp - reducedBy >= 0) {
                MobEffectInstance reducedEffectInstance = new MobEffectInstance(effect, duration, amp - reducedBy);
                entity.addEffect(reducedEffectInstance);
            }
        }
    }
}

