/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.common.registry;

import com.proststuff.arthritis.common.item.FirestarterItem;
import com.proststuff.arthritis.common.item.HatchetItem;
import com.proststuff.arthritis.common.item.PebblesItem;
import com.proststuff.arthritis.common.registry.ModMaterials;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"arthritis");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"arthritis");
    public static final DeferredItem<Item> PEBBLES = ITEMS.register("pebbles", PebblesItem::new);
    public static final DeferredItem<Item> FLINT_SHARD = ITEMS.registerSimpleItem("flint_shard");
    public static final DeferredItem<Item> FIBER = ITEMS.registerSimpleItem("fiber");
    public static final DeferredItem<FirestarterItem> FIRESTARTER = ITEMS.register("firestarter", FirestarterItem::new);
    public static final DeferredItem<HatchetItem> FLINT_HATCHET = ModItems.createHatchet("flint_hatchet", ModMaterials.FLINT, 3.5f, -2.4f);
    public static final DeferredItem<HatchetItem> IRON_HATCHET = ModItems.createHatchet("iron_hatchet", (Tier)Tiers.IRON, 3.0f, -2.325f);
    public static final DeferredItem<HatchetItem> GOLDEN_HATCHET = ModItems.createHatchet("golden_hatchet", (Tier)Tiers.GOLD, 3.0f, -2.25f);
    public static final DeferredItem<HatchetItem> DIAMOND_HATCHET = ModItems.createHatchet("diamond_hatchet", (Tier)Tiers.DIAMOND, 2.5f, -2.25f);
    public static final DeferredItem<HatchetItem> NETHERITE_HATCHET = ModItems.createHatchet("netherite_hatchet", (Tier)Tiers.NETHERITE, 2.5f, -2.25f);
    public static final Supplier<CreativeModeTab> ARTHRITIS = CREATIVE_MODE_TABS.register("arthritis", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.arthritis.main")).icon(() -> new ItemStack((ItemLike)FLINT_HATCHET.asItem())).displayItems((params, output) -> {
        output.accept(FLINT_HATCHET);
        output.accept(IRON_HATCHET);
        output.accept(GOLDEN_HATCHET);
        output.accept(DIAMOND_HATCHET);
        output.accept(NETHERITE_HATCHET);
        output.accept(FLINT_SHARD);
        output.accept(PEBBLES);
        output.accept(FIBER);
        output.accept(FIRESTARTER);
    }).build());

    public static void init(IEventBus eventBus) {
        ITEMS.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
    }

    private static DeferredItem<HatchetItem> createHatchet(String name, Tier tier, float damage, float speed) {
        return ITEMS.register(name, () -> new HatchetItem(tier, new Item.Properties().attributes(AxeItem.createAttributes((Tier)tier, (float)damage, (float)speed))));
    }
}

