/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.mixin;

import com.proststuff.arthritis.common.registry.ModDamageTypes;
import com.proststuff.arthritis.common.registry.ModEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockBehaviour.class})
public class BlockBehaviorMixin {
    @Inject(method={"entityInside"}, at={@At(value="HEAD")})
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, CallbackInfo ci) {
        if (entity instanceof ItemEntity) {
            return;
        }
        Block block = state.getBlock();
        DamageSource damageSource = ModDamageTypes.sawed(level);
        if (block instanceof CampfireBlock) {
            entity.igniteForSeconds(4.0f);
        } else if (block instanceof StonecutterBlock && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.hurtTime <= 0 && !living.isInvulnerableTo(damageSource) && entity.hurt(damageSource, 1.0f)) {
                ModEffects.applyBleed(living, 100);
            }
        }
    }
}

