/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.mixin;

import com.proststuff.arthritis.Config;
import java.util.List;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Shadow
    public abstract InteractionResult useOn(UseOnContext var1);

    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")})
    public void finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity, CallbackInfoReturnable<ItemStack> cir) {
        FoodProperties properties;
        if (stack.is(Tags.Items.FOODS_FOOD_POISONING) && !((Boolean)Config.COMMON.disableFoodPoisoning.get()).booleanValue() && (properties = stack.getFoodProperties(livingEntity)) != null) {
            List effects = properties.effects();
            boolean alreadyHavePoisonEffect = false;
            for (FoodProperties.PossibleEffect effect : effects) {
                if (!effect.effect().is(MobEffects.POISON)) continue;
                alreadyHavePoisonEffect = true;
                break;
            }
            if (!alreadyHavePoisonEffect && (double)level.getRandom().nextFloat() < (Double)Config.COMMON.foodPoisonProbability.get()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 300, ((Integer)Config.COMMON.foodPoisonAmplifier.get()).intValue()));
            }
        }
    }
}

