/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.mixin;

import com.proststuff.arthritis.common.datagen.ModItemTags;
import com.proststuff.arthritis.common.registry.ModEffects;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract ItemStack getItemInHand(InteractionHand var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    @Inject(method={"startUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void startUsingItem(InteractionHand hand, CallbackInfo ci) {
        boolean isValidAnim;
        ItemStack itemstack = this.getItemInHand(hand);
        UseAnim useAnim = itemstack.getUseAnimation();
        boolean ignoreFracture = itemstack.is(ModItemTags.IGNORE_FRACTURE_CHECK);
        boolean bl = isValidAnim = useAnim == UseAnim.EAT || useAnim == UseAnim.DRINK || useAnim == UseAnim.CUSTOM;
        if (!ignoreFracture && !isValidAnim) {
            boolean hasFracture;
            boolean bl2 = hasFracture = this.getEffect((Holder<MobEffect>)ModEffects.FRACTURE) != null;
            if (hasFracture) {
                ci.cancel();
            }
        }
    }
}

