/*
 * Decompiled with CFR 0.152.
 */
package com.proststuff.arthritis.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.proststuff.arthritis.Config;
import com.proststuff.arthritis.common.registry.ModEffects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    @Nullable
    protected abstract Player getCameraPlayer();

    @Inject(method={"renderHeart"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHeart(GuiGraphics guiGraphics, Gui.HeartType type, int x, int y, boolean pHardcore, boolean blinking, boolean half, CallbackInfo ci) {
        if (!type.equals((Object)Gui.HeartType.NORMAL) && !type.equals((Object)Gui.HeartType.CONTAINER) || !Config.CLIENT.renderCustomHearts.getAsBoolean()) {
            return;
        }
        boolean container = type.equals((Object)Gui.HeartType.CONTAINER);
        Player player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        if (player.hasEffect(ModEffects.AFTERBURN)) {
            GuiMixin.arthritis$render("afterburn", "arthritis", guiGraphics, x, y, half, blinking, container, false, ci);
        }
    }

    @Unique
    private static void arthritis$renderContainerAtEnd() {
    }

    @Unique
    private static void arthritis$render(String name, String namespace, GuiGraphics guiGraphics, int x, int y, boolean half, boolean blinking, boolean container, boolean shouldRenderContainer, CallbackInfo ci) {
        ResourceLocation texture = half ? ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("hud/heart/" + name + "_half")) : ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("hud/heart/" + name + "_full"));
        if (container) {
            if (!shouldRenderContainer) {
                return;
            }
            texture = blinking ? ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("hud/heart/" + name + "_container_blinking")) : ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("hud/heart/" + name + "_container"));
        }
        RenderSystem.enableBlend();
        guiGraphics.blitSprite(texture, x, y, 9, 9);
        RenderSystem.disableBlend();
        ci.cancel();
    }
}

