/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.gal.common.client;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import org.cneko.gal.common.Gal;

public class GalSoundInstance {
    private SoundPlayer musicPlayer;
    private SoundPlayer voicePlayer;
    private final Object musicLock = new Object();
    private final Object voiceLock = new Object();
    private static GalSoundInstance instance;

    public static GalSoundInstance getInstance() {
        if (instance == null) {
            instance = new GalSoundInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playMusic(String filePath, boolean loop) {
        Object object = this.musicLock;
        synchronized (object) {
            this.stopMusicInternal();
            if (filePath == null || filePath.isEmpty()) {
                Gal.LOGGER.error("BGM\u8def\u5f84\u662f\u7a7a\u7684\u5566\uff0c\u662f\u4e0d\u662f\u5fd8\u8bb0\u8bbe\u7f6e\u5566\uff1f");
                return;
            }
            Gal.LOGGER.info("\u6b63\u5728\u64ad\u653eBGM\uff1a{}{}", (Object)filePath, (Object)(loop ? " (\u5355\u66f2\u5faa\u73af\u4e2d~)" : ""));
            this.musicPlayer = new SoundPlayer(filePath, loop);
            this.musicPlayer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMusic() {
        Object object = this.musicLock;
        synchronized (object) {
            this.stopMusicInternal();
        }
    }

    private void stopMusicInternal() {
        if (this.musicPlayer != null) {
            this.musicPlayer.stop();
            this.musicPlayer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playVoice(String filePath) {
        Object object = this.voiceLock;
        synchronized (object) {
            this.stopVoiceInternal();
            if (filePath == null || filePath.isEmpty()) {
                Gal.LOGGER.error("\u8bed\u97f3\u8def\u5f84\u662f\u7a7a\u7684\u5566\uff0c\u662f\u4e0d\u662f\u5fd8\u8bb0\u8bbe\u7f6e\u5566\uff1f");
                return;
            }
            Gal.LOGGER.info("\u6b63\u5728\u5ff5\u8bed\u97f3\uff1a{}", (Object)filePath);
            this.voicePlayer = new SoundPlayer(filePath, false);
            this.voicePlayer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopVoice() {
        Object object = this.voiceLock;
        synchronized (object) {
            this.stopVoiceInternal();
        }
    }

    private void stopVoiceInternal() {
        if (this.voicePlayer != null) {
            this.voicePlayer.stop();
            this.voicePlayer = null;
        }
    }

    public void stopAllSounds() {
        Gal.LOGGER.info("\u6b63\u5728\u5173\u6389\u6240\u6709\u58f0\u97f3...\u5b89\u9759\u4e0b\u6765\u5566~");
        this.stopMusic();
        this.stopVoice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMusicPlaying() {
        Object object = this.musicLock;
        synchronized (object) {
            return this.musicPlayer != null && this.musicPlayer.isPlaying();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVoicePlaying() {
        Object object = this.voiceLock;
        synchronized (object) {
            return this.voicePlayer != null && this.voicePlayer.isPlaying();
        }
    }

    private static class SoundPlayer
    implements Runnable {
        private final String filePath;
        private final boolean loop;
        private volatile boolean playing;
        private Player activePlayer;
        private Thread playerThread;

        public SoundPlayer(String filePath, boolean loop) {
            this.filePath = filePath;
            this.loop = loop;
            this.playing = false;
        }

        public void start() {
            if (this.playerThread != null && this.playerThread.isAlive()) {
                Gal.LOGGER.error("\u8b66\u544a\uff1a\u8bd5\u56fe\u542f\u52a8\u4e00\u4e2a\u5df2\u7ecf\u5728\u5de5\u4f5c\u7684\u64ad\u653e\u7ebf\u7a0b {}", (Object)this.filePath);
                return;
            }
            this.playing = true;
            this.playerThread = new Thread((Runnable)this, "SoundPlayer-" + (this.loop ? "BGM-" : "\u8bed\u97f3-") + this.filePath.substring(this.filePath.lastIndexOf(47) + 1));
            this.playerThread.setDaemon(true);
            this.playerThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.playing) {
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.filePath));){
                    this.activePlayer = new Player((InputStream)is);
                    this.activePlayer.play();
                }
                catch (FileNotFoundException e) {
                    Gal.LOGGER.error("\u9519\u8bef\uff1a\u627e\u4e0d\u5230\u58f0\u97f3\u6587\u4ef6\u5566 {} - {}", (Object)this.filePath, (Object)e.getMessage());
                    this.playing = false;
                }
                catch (IOException | JavaLayerException e) {
                    if (this.playing) {
                        Gal.LOGGER.error("\u64ad\u653e {} \u65f6\u51fa\u9519\u5566\uff1a{}", (Object)this.filePath, (Object)e.getMessage());
                    }
                    this.playing = false;
                }
                finally {
                    if (this.activePlayer != null) {
                        this.activePlayer.close();
                        this.activePlayer = null;
                    }
                }
                if (this.loop && this.playing) continue;
            }
            this.playing = false;
        }

        public synchronized void stop() {
            this.playing = false;
            if (this.activePlayer != null) {
                this.activePlayer.close();
            }
        }

        public boolean isPlaying() {
            return this.playing && this.playerThread != null && this.playerThread.isAlive();
        }
    }
}

