/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.gal.common.client.parser;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.cneko.gal.common.Gal;
import org.cneko.gal.common.util.FileUtil;
import org.jetbrains.annotations.NotNull;

public class GalInfo {
    public static final Gson GSON = new Gson();
    @SerializedName(value="authors")
    private List<AuthorInfo> authors = new ArrayList<AuthorInfo>();
    @SerializedName(value="plots")
    private List<PlotInfo> plots = new ArrayList<PlotInfo>();

    @NotNull
    public List<PlotInfo> getPlots() {
        return this.plots;
    }

    public static GalInfo parse(Path path) {
        try {
            System.out.println();
            return (GalInfo)GSON.fromJson(FileUtil.inputStreamToString(FileUtil.readFile(path.toFile())), GalInfo.class);
        }
        catch (Exception e) {
            Gal.LOGGER.error("Failed to parse gal info", (Throwable)e);
            return null;
        }
    }

    @Generated
    public void setAuthors(List<AuthorInfo> authors) {
        this.authors = authors;
    }

    @Generated
    public void setPlots(List<PlotInfo> plots) {
        this.plots = plots;
    }

    @Generated
    public List<AuthorInfo> getAuthors() {
        return this.authors;
    }

    public static class PlotInfo {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="desc")
        private String desc;

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDesc(String desc) {
            this.desc = desc;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDesc() {
            return this.desc;
        }
    }

    public static class AuthorInfo {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="role")
        private String role;

        public List<String> getRole() {
            return List.of(this.role.split(","));
        }

        public String getRoleAsString() {
            return this.role;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setRole(String role) {
            this.role = role;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

