/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.gal.common.client.parser;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.cneko.gal.common.client.parser.GalInfo;
import org.cneko.gal.common.client.parser.GalPictureReader;
import org.cneko.gal.common.client.parser.GalSoundPlayer;
import org.cneko.gal.common.client.parser.PlotParser;
import org.cneko.gal.common.util.FileUtil;

public class GalParser {
    private static final String GAL_INFO_FILE_NAME = "main.json";
    private static final String PLOT_DIRECTORY_NAME = "plots";
    private final Path path;
    private final GalInfo galInfo;
    private final List<Map<String, PlotParser.DialogueNode>> plotParsers = new ArrayList<Map<String, PlotParser.DialogueNode>>();
    private final GalSoundPlayer soundPlayer;
    private final GalPictureReader pictureReader;

    public GalParser(Path path) {
        this.path = path;
        this.galInfo = GalInfo.parse(Path.of(path.toString(), GAL_INFO_FILE_NAME));
        for (GalInfo.PlotInfo plotInfo : this.galInfo.getPlots()) {
            String name = plotInfo.getName();
            this.plotParsers.add(PlotParser.parseDialogueTree(FileUtil.getFileReader(Path.of(path.toString(), PLOT_DIRECTORY_NAME, name + ".json"))));
        }
        this.soundPlayer = new GalSoundPlayer(Path.of(path.toString(), "sounds"));
        this.pictureReader = new GalPictureReader(Path.of(path.toString(), "pictures"));
    }

    @Generated
    public Path getPath() {
        return this.path;
    }

    @Generated
    public GalInfo getGalInfo() {
        return this.galInfo;
    }

    @Generated
    public List<Map<String, PlotParser.DialogueNode>> getPlotParsers() {
        return this.plotParsers;
    }

    @Generated
    public GalSoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    @Generated
    public GalPictureReader getPictureReader() {
        return this.pictureReader;
    }
}

