/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.gal.common.client.parser;

import java.nio.file.Path;
import org.cneko.gal.common.client.GalSoundInstance;
import org.jetbrains.annotations.NotNull;

public class GalSoundPlayer {
    private final Path soundPath;
    private final GalSoundInstance instance = GalSoundInstance.getInstance();

    public GalSoundPlayer(Path soundPath) {
        this.soundPath = soundPath;
    }

    public void stopAll() {
        this.stopMusic();
        this.stopVoice();
    }

    public void stopMusic() {
        this.instance.stopMusic();
    }

    public void stopVoice() {
        this.instance.stopVoice();
    }

    public void playMusic(String name, boolean loop) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.instance.playMusic(this.getMusicPath(name), loop);
    }

    public void playVoice(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.instance.playVoice(this.getVoicePath(name));
    }

    @NotNull
    private String getMusicPath(String name) {
        return this.soundPath.resolve("music").resolve(name + ".mp3").toString();
    }

    @NotNull
    private String getVoicePath(String name) {
        return this.soundPath.resolve("voices").resolve(name + ".mp3").toString();
    }
}

