/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.gal.common.client.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class PlotParser {
    public static Map<String, DialogueNode> parseDialogueTree(Reader jsonReader) {
        Gson gson = new GsonBuilder().create();
        Type type = new TypeToken<Map<String, DialogueNode>>(){}.getType();
        return (Map)gson.fromJson(jsonReader, type);
    }

    public static class BigPicture {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="show_text")
        private boolean showText;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean isShowText() {
            return this.showText;
        }
    }

    public static class StandPicture {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="height")
        private int height;
        @SerializedName(value="width")
        private int width;
        @SerializedName(value="x_offset")
        private float xOffset;
        @SerializedName(value="y_offset")
        private float yOffset;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public float getXOffset() {
            return this.xOffset;
        }

        @Generated
        public float getYOffset() {
            return this.yOffset;
        }
    }

    public static class Choice {
        @SerializedName(value="text")
        private String text;
        @SerializedName(value="next")
        private String next;

        public String toString() {
            return "Choice{text='" + this.text + "', next='" + this.next + "'}";
        }

        public boolean nextShouldEnd() {
            return this.next == null || this.next.isEmpty() || this.next.equals("end");
        }

        @Nullable
        public String getNextPlotIfShouldBeSwitch() {
            if (this.next.startsWith("plot:")) {
                return this.next.substring(5);
            }
            return null;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getNext() {
            return this.next;
        }
    }

    public static class DialogueNode {
        @SerializedName(value="character")
        private String character;
        @SerializedName(value="big_picture")
        private BigPicture bigPicture;
        @SerializedName(value="stand_picture")
        private StandPicture standPicture;
        @SerializedName(value="music")
        private String music;
        @SerializedName(value="text")
        private String text;
        @SerializedName(value="voice")
        private String voice;
        @SerializedName(value="choices")
        private List<Choice> choices;
        @SerializedName(value="next")
        private String next;

        public String getCV() {
            if (this.voice == null || this.voice.isEmpty()) {
                return null;
            }
            String[] split = this.voice.split("/");
            return split[0];
        }

        public boolean nextShouldEnd() {
            return this.next == null || this.next.isEmpty() || this.next.equals("end");
        }

        @Nullable
        public String getNextPlotIfShouldBeSwitch() {
            if (this.next.startsWith("plot:")) {
                return this.next.substring(5);
            }
            return null;
        }

        @Generated
        public String getCharacter() {
            return this.character;
        }

        @Generated
        public BigPicture getBigPicture() {
            return this.bigPicture;
        }

        @Generated
        public StandPicture getStandPicture() {
            return this.standPicture;
        }

        @Generated
        public String getMusic() {
            return this.music;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getVoice() {
            return this.voice;
        }

        @Generated
        public List<Choice> getChoices() {
            return this.choices;
        }

        @Generated
        public String getNext() {
            return this.next;
        }
    }
}

