/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.gal.common.client.screen;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.cneko.gal.common.Gal;
import org.cneko.gal.common.client.parser.GalInfo;
import org.cneko.gal.common.client.parser.GalParser;
import org.cneko.gal.common.client.parser.GalPictureReader;
import org.cneko.gal.common.client.parser.PlotParser;
import org.cneko.gal.common.util.TextureUtil;
import org.jetbrains.annotations.NotNull;

public class DialogueScreen
extends class_437 {
    private final GalParser parser;
    private PlotParser.DialogueNode currentNode;
    private Map<String, PlotParser.DialogueNode> currentPlotNodes;
    private int currentPlotIndex = 0;
    private final Map<String, class_2960> cachedTextures = new HashMap<String, class_2960>();
    private String activeStandPicturePath;
    private PlotParser.StandPicture lastValidStandPictureInfo;
    private int lastValidStandPictureHeight = 0;
    private int lastValidStandPictureWidth = 0;
    private String activeCharacterName;
    private String activeMusicPath;
    private String currentBigPicturePath;
    private class_2960 activeBigPictureTexture;
    private boolean showTextWindow;
    private int textDisplayProgress;
    private long lastUpdateTime;
    private static final int CHAR_DELAY = 20;
    private static final int TEXT_WINDOW_HEIGHT = 80;
    private static final int TEXT_AREA_SIDE_MARGIN = 40;
    private static final float TEXT_SCALE_FACTOR = 1.1f;

    public DialogueScreen(GalParser parser) {
        super((class_2561)class_2561.method_43473());
        this.parser = parser;
        this.activeStandPicturePath = null;
        this.lastValidStandPictureInfo = null;
        this.activeCharacterName = null;
        this.activeMusicPath = null;
        this.currentBigPicturePath = null;
        this.activeBigPictureTexture = null;
        this.showTextWindow = true;
        if (this.parser.getPlotParsers() != null && !this.parser.getPlotParsers().isEmpty()) {
            this.currentPlotIndex = 0;
            this.currentPlotNodes = this.parser.getPlotParsers().get(this.currentPlotIndex);
        } else {
            Gal.LOGGER.error("\u54ce\u5440\u5440\uff01\u89e3\u6790\u5668\u91cc\u7a7a\u7a7a\u7684\uff0c\u6728\u6709\u5267\u60c5\u6570\u636e\u8036\u3002\u5bf9\u8bdd\u754c\u9762\u8981\u7f62\u5de5\u5566\uff01");
            this.currentPlotNodes = new HashMap<String, PlotParser.DialogueNode>();
        }
        this.loadNode("0");
    }

    protected void method_25426() {
        super.method_25426();
        this.updateButtons();
    }

    public void method_25393() {
        super.method_25393();
        if (this.currentBigPicturePath == null || this.activeBigPictureTexture == null || this.showTextWindow) {
            this.updateTextProgress();
        }
    }

    private void loadNode(String nodeId) {
        if (nodeId == null || nodeId.equalsIgnoreCase("end")) {
            this.method_25419();
            return;
        }
        if (nodeId.startsWith("plot:")) {
            String plotName = nodeId.substring(5);
            Gal.LOGGER.info("\u55ef\u54fc\uff1f\u662f\u60f3\u8981\u6362\u5230 '{}' \u8fd9\u4e2a\u5267\u60c5\u54a9\uff1f\u7a9d\u6765\u8bd5\u8bd5\u770b\uff01", (Object)plotName);
            List<GalInfo.PlotInfo> plotInfos = this.parser.getGalInfo().getPlots();
            boolean switched = false;
            for (int i = 0; i < plotInfos.size(); ++i) {
                if (!plotInfos.get(i).getName().equals(plotName)) continue;
                if (this.parser.getPlotParsers() != null && i < this.parser.getPlotParsers().size()) {
                    this.currentPlotIndex = i;
                    this.currentPlotNodes = this.parser.getPlotParsers().get(i);
                    Gal.LOGGER.info("\u6362\u597d\u5566\uff01\u73b0\u5728\u662f\u5267\u60c5 '{}' (\u662f\u7b2c {} \u4e2a\u54e6~)\u3002\u6b63\u5728\u52a0\u8f7d\u5b83\u7684 '0' \u53f7\u5c0f\u6545\u4e8b\u70b9\u70b9\u3002", (Object)plotName, (Object)i);
                    this.loadNode("0");
                    switched = true;
                    break;
                }
                Gal.LOGGER.error("\u545c\u545c\u545c\uff0c\u5267\u60c5 '{}' \u5728 GalInfo \u5217\u8868\u91cc\u662f\u627e\u5230\u4e86\uff0c\u53ef\u662f\u5728\u7b2c {} \u4e2a\u4f4d\u7f6e\u6728\u6709\u89e3\u6790\u597d\u7684\u6570\u636e\u5440QAQ\u3002", (Object)plotName, (Object)i);
                break;
            }
            if (switched) {
                return;
            }
            Gal.LOGGER.error("\u6362\u5230\u5267\u60c5 '{}' \u5931\u8d25\u4e86QAQ\u3002\u53ef\u80fd GalInfo \u91cc\u6ca1\u6709\u8fd9\u4e2a\u5267\u60c5\uff0c\u6216\u8005\u6570\u636e\u4e0d\u89c1\u4e86\u3002\u8fd8\u662f\u7ee7\u7eed\u73b0\u5728\u7684\u5267\u60c5\u597d\u5566\u3002", (Object)plotName);
        }
        if (this.currentPlotNodes == null) {
            Gal.LOGGER.error("currentPlotNodes \u5c45\u7136\u662f\u7a7a\u7684\u8036\uff01\u52a0\u8f7d\u4e0d\u4e86 '{}' \u8fd9\u4e2a\u8282\u70b9\u4e86\uff0c\u5c4f\u5e55\u8981\u5173\u6389\u6389\u5566\u3002", (Object)nodeId);
            this.method_25419();
            return;
        }
        if (this.currentPlotNodes.containsKey(nodeId)) {
            this.currentNode = this.currentPlotNodes.get(nodeId);
            boolean isOldBigPictureAlive = this.currentBigPicturePath != null;
            this.currentBigPicturePath = null;
            this.activeBigPictureTexture = null;
            PlotParser.BigPicture bigPicture = this.currentNode.getBigPicture();
            if (bigPicture != null && !bigPicture.getName().isEmpty()) {
                this.currentBigPicturePath = bigPicture.getName();
                this.loadBigPicture(this.currentBigPicturePath);
                if (!bigPicture.isShowText()) {
                    this.showTextWindow = false;
                }
            } else if (isOldBigPictureAlive) {
                this.showTextWindow = true;
            }
            this.handleNodeResources();
            this.resetTextDisplay();
            this.updateButtons();
        } else {
            Object currentPlotName = "\u4e0d\u77e5\u9053\u662f\u54ea\u4e2a\u5267\u60c5 (\u7f16\u53f7 " + this.currentPlotIndex + ")";
            if (this.parser.getGalInfo() != null && this.parser.getGalInfo().getPlots().size() > this.currentPlotIndex) {
                currentPlotName = this.parser.getGalInfo().getPlots().get(this.currentPlotIndex).getName();
            }
            Gal.LOGGER.warn("\u55ef\uff1f\u8282\u70b9 '{}' \u5728\u5f53\u524d\u5267\u60c5 '{}' \u91cc\u597d\u50cf\u4e0d\u89c1\u4e86\u8036\u3002", (Object)nodeId, currentPlotName);
            if (!"0".equals(nodeId)) {
                Gal.LOGGER.info("\u627e\u4e0d\u5230\u7684\u8bdd\uff0c\u8bd5\u7740\u52a0\u8f7d\u5f53\u524d\u5267\u60c5 '{}' \u7684\u8d77\u59cb\u8282\u70b9 '0' \u770b\u770b\u5427\uff0c\u8bf4\u4e0d\u5b9a\u53ef\u4ee5\u5462\u3002", currentPlotName);
                this.loadNode("0");
            } else {
                Gal.LOGGER.error("\u7cdf\u7cd5\uff01\u521d\u59cb\u8282\u70b9 '0' \u5728\u5f53\u524d\u5267\u60c5 '{}' \u91cc\u627e\u4e0d\u5230\u5566\uff01\u8fd9\u4e2a\u5267\u60c5\u52a0\u8f7d\u4e0d\u4e86\u4e86\u545c\u545c\u545c\u3002", currentPlotName);
                this.method_25419();
            }
        }
    }

    private void resetTextDisplay() {
        this.textDisplayProgress = 0;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    private void handleNodeResources() {
        String newMusic;
        PlotParser.StandPicture newStandPicInfoFromNode;
        if (this.currentNode == null) {
            return;
        }
        String newCharacterName = this.currentNode.getCharacter();
        if (newCharacterName != null) {
            this.activeCharacterName = newCharacterName.equalsIgnoreCase("none") ? null : newCharacterName;
        }
        if ((newStandPicInfoFromNode = this.currentNode.getStandPicture()) != null) {
            this.lastValidStandPictureInfo = newStandPicInfoFromNode;
            String newImageName = newStandPicInfoFromNode.getName();
            if (newImageName != null) {
                if (newImageName.equalsIgnoreCase("none")) {
                    this.activeStandPicturePath = null;
                    this.lastValidStandPictureInfo = null;
                } else if (!newImageName.equals(this.activeStandPicturePath)) {
                    this.activeStandPicturePath = newImageName;
                    this.loadPortrait(this.activeStandPicturePath);
                }
            }
        }
        if (this.parser.getSoundPlayer() != null && (newMusic = this.currentNode.getMusic()) != null) {
            if (newMusic.equalsIgnoreCase("none")) {
                if (this.activeMusicPath != null) {
                    this.parser.getSoundPlayer().stopMusic();
                    this.activeMusicPath = null;
                }
            } else if (!newMusic.equals(this.activeMusicPath)) {
                this.parser.getSoundPlayer().playMusic(newMusic, true);
                this.activeMusicPath = newMusic;
            }
        }
        if (this.currentNode.getVoice() != null && this.parser.getSoundPlayer() != null) {
            if (this.currentNode.getVoice().equalsIgnoreCase("none")) {
                this.parser.getSoundPlayer().stopVoice();
            } else {
                this.parser.getSoundPlayer().playVoice(this.currentNode.getVoice());
            }
        }
    }

    private void loadPortrait(String imagePath) {
        if (imagePath == null || imagePath.isEmpty()) {
            Gal.LOGGER.warn("\u60f3\u8981\u52a0\u8f7d\u7acb\u7ed8\uff0c\u4f46\u662f\u8def\u5f84\u662f\u7a7a\u7684\u6216\u8005\u7a7a\u7a7a\u7684\u5b57\u7b26\u4e32\u8036~");
            return;
        }
        if (this.cachedTextures.containsKey(imagePath)) {
            if (this.cachedTextures.get(imagePath) == null) {
                Gal.LOGGER.debug("\u7acb\u7ed8'{}'\u4e4b\u524d\u52a0\u8f7d\u5931\u8d25\u8fc7\u5566\uff0c\u8fd9\u6b21\u5c31\u8df3\u8fc7\uff0c\u4e0d\u8bd5\u5566~", (Object)imagePath);
            }
            return;
        }
        try {
            Gal.LOGGER.debug("\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u7acb\u7ed8: {} ~", (Object)imagePath);
            GalPictureReader.Picture picture = this.parser.getPictureReader().readStandPicture(imagePath);
            if (picture == null || picture.stream() == null) {
                Gal.LOGGER.error("\u62ff\u4e0d\u5230\u7acb\u7ed8'{}'\u7684\u8f93\u5165\u6d41\u6216\u8005\u56fe\u7247\u5bf9\u8c61\u8036\uff0c\u662f\u4e0d\u662f\u8def\u5f84\u5199\u9519\u5566\uff1f", (Object)imagePath);
                this.cachedTextures.put(imagePath, null);
                return;
            }
            InputStream is = picture.stream();
            this.lastValidStandPictureHeight = picture.height();
            this.lastValidStandPictureWidth = picture.width();
            try (InputStream inputStream = is;){
                class_2960 texture = TextureUtil.registerTexture(imagePath, is);
                this.cachedTextures.put(imagePath, texture);
                Gal.LOGGER.debug("\u7acb\u7ed8: {} \u52a0\u8f7d\u6210\u529f\u5566\uff01\u597d\u8036\uff01", (Object)imagePath);
            }
            catch (IOException e) {
                Gal.LOGGER.error("\u5173\u95ed\u7acb\u7ed8 '{}' \u8f93\u5165\u6d41\u7684\u65f6\u5019\uff0c\u51fa\u9519\u4e86\u545c\u545c~", (Object)imagePath, (Object)e);
                this.cachedTextures.put(imagePath, null);
            }
            catch (Exception e) {
                Gal.LOGGER.error("\u6ce8\u518c\u7acb\u7ed8\u7eb9\u7406'{}'\u7684\u65f6\u5019\uff0c\u4e5f\u51fa\u9519\u4e86QAQ~", (Object)imagePath, (Object)e);
                this.cachedTextures.put(imagePath, null);
            }
        }
        catch (Exception e) {
            Gal.LOGGER.error("\u52a0\u8f7d\u7acb\u7ed8'{}'\u7684\u65f6\u5019\uff0c\u53d1\u751f\u4e86\u610f\u60f3\u4e0d\u5230\u7684\u72b6\u51b5\u5462~", (Object)imagePath, (Object)e);
            this.cachedTextures.put(imagePath, null);
        }
    }

    private void loadBigPicture(String imagePath) {
        if (imagePath == null || imagePath.isEmpty()) {
            Gal.LOGGER.warn("\u60f3\u52a0\u8f7d\u5927\u56fe\u56fe\uff0c\u4f46\u662f\u8def\u5f84\u662f\u7a7a\u7684\u6216\u8005\u7a7a\u7a7a\u7684\u5b57\u7b26\u4e32\u8036~");
            this.activeBigPictureTexture = null;
            return;
        }
        if (this.cachedTextures.containsKey(imagePath)) {
            this.activeBigPictureTexture = this.cachedTextures.get(imagePath);
            if (this.activeBigPictureTexture == null) {
                Gal.LOGGER.debug("\u5927\u56fe\u56fe'{}'\u4e4b\u524d\u52a0\u8f7d\u5931\u8d25\u8fc7\u5566\uff0c\u8fd9\u6b21\u5c31\u8df3\u8fc7\uff0c\u4e0d\u8bd5\u5566~", (Object)imagePath);
            }
            return;
        }
        try {
            Gal.LOGGER.debug("\u6b63\u5728\u52aa\u529b\u52a0\u8f7d\u5927\u56fe\u56fe: {} ~", (Object)imagePath);
            GalPictureReader.Picture picture = this.parser.getPictureReader().readBigPicture(imagePath);
            if (picture == null || picture.stream() == null) {
                Gal.LOGGER.error("\u62ff\u4e0d\u5230\u5927\u56fe\u56fe'{}'\u7684\u8f93\u5165\u6d41\u6216\u8005\u56fe\u7247\u5bf9\u8c61\u8036\uff0c\u662f\u4e0d\u662f\u8def\u5f84\u5199\u9519\u5566\uff1f", (Object)imagePath);
                this.cachedTextures.put(imagePath, null);
                this.activeBigPictureTexture = null;
                return;
            }
            try (InputStream is = picture.stream();){
                class_2960 texture = TextureUtil.registerTexture(imagePath, is);
                this.cachedTextures.put(imagePath, texture);
                this.activeBigPictureTexture = texture;
                Gal.LOGGER.debug("\u5927\u56fe\u56fe: {} \u52a0\u8f7d\u6210\u529f\u5566\uff01\u68d2\u68d2\uff01", (Object)imagePath);
            }
            catch (IOException e) {
                Gal.LOGGER.error("\u5173\u95ed\u5927\u56fe\u56fe '{}' \u8f93\u5165\u6d41\u7684\u65f6\u5019\uff0c\u51fa\u9519\u4e86\u545c\u545c~", (Object)imagePath, (Object)e);
                this.cachedTextures.put(imagePath, null);
                this.activeBigPictureTexture = null;
            }
            catch (Exception e) {
                Gal.LOGGER.error("\u6ce8\u518c\u5927\u56fe\u56fe\u7eb9\u7406'{}'\u7684\u65f6\u5019\uff0c\u4e5f\u51fa\u9519\u4e86QAQ~", (Object)imagePath, (Object)e);
                this.cachedTextures.put(imagePath, null);
                this.activeBigPictureTexture = null;
            }
        }
        catch (Exception e) {
            Gal.LOGGER.error("\u52a0\u8f7d\u5927\u56fe\u56fe'{}'\u7684\u65f6\u5019\uff0c\u53d1\u751f\u4e86\u610f\u60f3\u4e0d\u5230\u7684\u72b6\u51b5\u5462~", (Object)imagePath, (Object)e);
            this.cachedTextures.put(imagePath, null);
            this.activeBigPictureTexture = null;
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.currentBigPicturePath != null && this.activeBigPictureTexture != null) {
            this.renderBigPicture(guiGraphics);
        } else {
            this.renderPortraits(guiGraphics);
        }
        if (this.showTextWindow) {
            this.renderTextWindow(guiGraphics);
        }
        if (this.activeMusicPath != null && !this.activeMusicPath.isEmpty()) {
            String musicDisplayName = this.getMusicDisplayName();
            guiGraphics.method_25303(this.field_22793, "\u266a " + musicDisplayName, 5, 5, 0xFFFFFF);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderBigPicture(class_332 guiGraphics) {
        if (this.activeBigPictureTexture != null) {
            guiGraphics.method_25290(this.activeBigPictureTexture, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, this.field_22789, this.field_22790);
        }
    }

    @NotNull
    private String getMusicDisplayName() {
        int dotIndex;
        String musicDisplayName = this.activeMusicPath;
        if (musicDisplayName.contains("/")) {
            musicDisplayName = musicDisplayName.substring(musicDisplayName.lastIndexOf(47) + 1);
        }
        if (musicDisplayName.contains("\\")) {
            musicDisplayName = musicDisplayName.substring(musicDisplayName.lastIndexOf(92) + 1);
        }
        if ((dotIndex = musicDisplayName.lastIndexOf(46)) > 0) {
            musicDisplayName = musicDisplayName.substring(0, dotIndex);
        }
        return musicDisplayName;
    }

    private void renderPortraits(class_332 guiGraphics) {
        if (this.activeStandPicturePath != null && this.lastValidStandPictureInfo != null) {
            class_2960 texture = this.cachedTextures.get(this.activeStandPicturePath);
            PlotParser.StandPicture standPictureInfo = this.lastValidStandPictureInfo;
            if (texture != null && standPictureInfo != null) {
                String nameInInfo = standPictureInfo.getName();
                if (nameInInfo != null && nameInInfo.equalsIgnoreCase("none")) {
                    return;
                }
                int picWidth = standPictureInfo.getWidth();
                int picHeight = standPictureInfo.getHeight();
                if ((picWidth <= 0 || picHeight <= 0) && this.lastValidStandPictureWidth > 0 && this.lastValidStandPictureHeight > 0) {
                    picHeight = (int)((double)this.field_22790 * 0.9);
                    picWidth = picHeight * this.lastValidStandPictureWidth / this.lastValidStandPictureHeight;
                } else if (picWidth <= 0 || picHeight <= 0) {
                    Gal.LOGGER.warn("\u7acb\u7ed8 '{}' \u7684\u5c3a\u5bf8\u4fe1\u606f\u4e0d\u5bf9\u8036 (\u5bbd:{}, \u9ad8:{}), \u800c\u4e14\u4e5f\u6ca1\u6709\u7f13\u5b58\u7684\u5c3a\u5bf8\uff0c\u53ef\u80fd\u753b\u4e0d\u51fa\u6765\u6216\u8005\u753b\u5f97\u602a\u602a\u7684\u54e6\u3002", (Object)this.activeStandPicturePath, (Object)picWidth, (Object)picHeight);
                    return;
                }
                float xOffsetPercent = standPictureInfo.getXOffset();
                float yOffsetPercent = standPictureInfo.getYOffset();
                if (xOffsetPercent <= 0.0f) {
                    float widthPercent = (float)picWidth / (float)this.field_22789;
                    xOffsetPercent = (1.0f - widthPercent) / 2.0f;
                }
                if (yOffsetPercent <= 0.0f) {
                    yOffsetPercent = 0.1f;
                }
                int portraitX = (int)((float)this.field_22789 * xOffsetPercent);
                int imageBottomY = (int)((float)this.field_22790 * (1.0f - yOffsetPercent));
                int portraitY = imageBottomY - picHeight;
                guiGraphics.method_25290(texture, portraitX, portraitY, 0.0f, 0.0f, picWidth, picHeight, picWidth, picHeight);
            }
        }
    }

    private void renderTextWindow(class_332 guiGraphics) {
        String displayedText;
        String fullText;
        String cvName;
        float f;
        int topColor = -1426079541;
        int bottomColor = 16761035;
        guiGraphics.method_25296(0, this.field_22790 - 80, this.field_22789, this.field_22790, topColor, bottomColor);
        if (this.currentNode == null) {
            return;
        }
        Objects.requireNonNull(this.field_22793);
        float scaledFontHeight = 9.0f * 1.1f;
        int nameAndCvLineY = this.field_22790 - 80 + 10;
        if (this.activeCharacterName != null && !this.activeCharacterName.isEmpty() || this.currentNode.getCV() != null && !this.currentNode.getCV().isEmpty() && !this.currentNode.getCV().equalsIgnoreCase("none")) {
            f = scaledFontHeight;
        } else {
            Objects.requireNonNull(this.field_22793);
            f = 9.0f;
        }
        float actualNameLineHeight = f;
        int dialogueTextY = nameAndCvLineY + (int)actualNameLineHeight + 5;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        if (this.activeCharacterName != null && !this.activeCharacterName.isEmpty()) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(40.0f, (float)nameAndCvLineY, 0.0f);
            guiGraphics.method_51448().method_22905(1.1f, 1.1f, 1.0f);
            guiGraphics.method_25303(this.field_22793, this.activeCharacterName, 0, 0, 0xFFFFFF);
            guiGraphics.method_51448().method_22909();
        }
        if ((cvName = this.currentNode.getCV()) != null && !cvName.isEmpty() && !cvName.equalsIgnoreCase("none")) {
            String cvText = "CV: " + cvName;
            int cvNameWidth = (int)((float)this.field_22793.method_1727(cvText) * 1.1f);
            int cvX = this.field_22789 - 40 - cvNameWidth;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)cvX, (float)nameAndCvLineY, 0.0f);
            guiGraphics.method_51448().method_22905(1.1f, 1.1f, 1.0f);
            guiGraphics.method_25303(this.field_22793, cvText, 0, 0, 0xCCCCCC);
            guiGraphics.method_51448().method_22909();
        }
        if ((fullText = this.currentNode.getText()) == null) {
            fullText = "";
        }
        if (!(displayedText = fullText.substring(0, Math.min(this.textDisplayProgress, fullText.length()))).isEmpty()) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(40.0f, (float)dialogueTextY, 0.0f);
            guiGraphics.method_51448().method_22905(1.1f, 1.1f, 1.0f);
            int wrapWidth = (int)((float)(this.field_22789 - 80) / 1.1f);
            guiGraphics.method_51440(this.field_22793, (class_5348)class_2561.method_43470((String)displayedText), 0, 0, wrapWidth, 0xFFFFFF);
            guiGraphics.method_51448().method_22909();
        }
        guiGraphics.method_51448().method_22909();
    }

    private void updateTextProgress() {
        long currentTime;
        if (this.currentNode == null || this.currentNode.getText() == null) {
            return;
        }
        if (this.textDisplayProgress < this.currentNode.getText().length() && (currentTime = System.currentTimeMillis()) - this.lastUpdateTime >= 20L) {
            ++this.textDisplayProgress;
            this.lastUpdateTime = currentTime;
            if (this.textDisplayProgress >= this.currentNode.getText().length()) {
                this.updateButtons();
            }
        }
    }

    private void updateButtons() {
        this.method_37067();
        if (this.currentBigPicturePath != null && this.activeBigPictureTexture != null) {
            return;
        }
        if (this.currentNode == null || this.currentNode.getText() == null) {
            return;
        }
        if (this.textDisplayProgress >= this.currentNode.getText().length() && this.currentNode.getChoices() != null && !this.currentNode.getChoices().isEmpty()) {
            int buttonWidth = 180;
            int buttonHeight = 20;
            int buttonMargin = 5;
            int numChoices = this.currentNode.getChoices().size();
            int buttonX = this.field_22789 - buttonWidth - 20;
            int totalButtonBlockHeight = numChoices * buttonHeight + Math.max(0, numChoices - 1) * buttonMargin;
            int topYForAllButtons = this.field_22790 - 80 - buttonMargin - totalButtonBlockHeight;
            topYForAllButtons = Math.max(10, topYForAllButtons);
            for (int i = 0; i < numChoices; ++i) {
                PlotParser.Choice choice = this.currentNode.getChoices().get(i);
                int currentButtonY = topYForAllButtons + i * (buttonHeight + buttonMargin);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)choice.getText()), button -> this.handleChoice(choice)).method_46433(buttonX, currentButtonY).method_46437(buttonWidth, buttonHeight).method_46431());
            }
        }
    }

    private void handleChoice(PlotParser.Choice choice) {
        if (choice.nextShouldEnd()) {
            this.method_25419();
        } else {
            this.loadNode(choice.getNext());
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int buttonType) {
        if (super.method_25402(mouseX, mouseY, buttonType)) {
            return true;
        }
        if (buttonType == 1) {
            this.showTextWindow = !this.showTextWindow;
            return true;
        }
        if (buttonType == 0) {
            return this.quickProcessText();
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32 || keyCode == 257 || keyCode == 341 || keyCode == 345) {
            return this.quickProcessText();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean quickProcessText() {
        if (this.currentBigPicturePath != null && this.activeBigPictureTexture != null) {
            this.proceedToNextNode();
            return true;
        }
        if (this.currentNode == null || this.currentNode.getText() == null) {
            Gal.LOGGER.warn("\u54a6\uff1f\u9f20\u6807\u70b9\u70b9\u7684\u65f6\u5019\uff0c\u8282\u70b9\u6216\u8005\u6587\u5b57\u597d\u50cf\u4e0d\u592a\u5bf9\u52b2\u8036\u3002\u7a9d\u8bd5\u8bd5\u52a0\u8f7d '0' \u53f7\u8d77\u59cb\u8282\u70b9\u770b\u770b\u597d\u4e0d\u597d...");
            this.loadNode("0");
            return true;
        }
        if (this.textDisplayProgress < this.currentNode.getText().length()) {
            this.textDisplayProgress = this.currentNode.getText().length();
            this.lastUpdateTime = System.currentTimeMillis();
            this.updateButtons();
        } else if (this.currentNode.getChoices() == null || this.currentNode.getChoices().isEmpty()) {
            this.proceedToNextNode();
        }
        return true;
    }

    private void proceedToNextNode() {
        if (this.currentNode == null) {
            Gal.LOGGER.warn("\u60f3\u8981\u7ee7\u7eed\u5230\u4e0b\u4e00\u4e2a\u8282\u70b9\uff0c\u4f46\u662f currentNode \u5c45\u7136\u662f\u7a7a\u7684\uff01\u7a9d\u8bd5\u8bd5\u52a0\u8f7d '0' \u53f7\u8282\u70b9\u597d\u5566...");
            this.loadNode("0");
            return;
        }
        if (this.currentNode.nextShouldEnd()) {
            this.method_25419();
        } else {
            this.loadNode(this.currentNode.getNext());
        }
    }

    public void method_25419() {
        if (this.parser != null && this.parser.getSoundPlayer() != null) {
            this.parser.getSoundPlayer().stopAll();
        }
        if (this.field_22787 != null) {
            this.cachedTextures.values().forEach(texture -> {
                if (texture != null) {
                    this.field_22787.method_1531().method_4615(texture);
                }
            });
        }
        this.cachedTextures.clear();
        this.activeBigPictureTexture = null;
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }
}

