/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.gal.common.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileUtil {
    public static InputStream readFile(File file) {
        try {
            return file.toURI().toURL().openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Reader getFileReader(Path path) {
        try {
            return Files.newBufferedReader(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String inputStreamToString(InputStream inputStream) {
        try {
            return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] getPngDimensions(InputStream is) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(is);
        byte[] signature = new byte[8];
        dataInputStream.readFully(signature);
        if (!FileUtil.isPngSignature(signature)) {
            throw new IOException("\u4e0d\u662f\u6709\u6548\u7684PNG\u6587\u4ef6");
        }
        int chunkLength = dataInputStream.readInt();
        byte[] chunkType = new byte[4];
        dataInputStream.readFully(chunkType);
        if (!"IHDR".equals(new String(chunkType))) {
            throw new IOException("PNG\u6587\u4ef6\u6ca1\u6709\u6709\u6548\u7684IHDR\u5757");
        }
        int width = dataInputStream.readInt();
        int height = dataInputStream.readInt();
        return new int[]{width, height};
    }

    private static boolean isPngSignature(byte[] bytes) {
        if (bytes == null || bytes.length < 8) {
            return false;
        }
        return bytes[0] == -119 && bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71 && bytes[4] == 13 && bytes[5] == 10 && bytes[6] == 26 && bytes[7] == 10;
    }
}

