/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.api;

import java.util.ArrayList;
import java.util.List;
import org.cneko.toneko.common.mod.util.ITickable;

public class TickTasks {
    public static final List<ITickable> CLIENT_TASKS = new ArrayList<ITickable>();
    public static final List<ITickable> TASKS = new ArrayList<ITickable>();

    public static void add(ITickable task) {
        TASKS.add(task);
    }

    public static void addClient(ITickable task) {
        CLIENT_TASKS.add(task);
    }

    public static void remove(ITickable task) {
        TASKS.remove(task);
    }

    public static void removeClient(ITickable task) {
        CLIENT_TASKS.remove(task);
    }

    public static void tick() {
        new ArrayList<ITickable>(TASKS).forEach(t -> t.addTick(1));
    }

    public static void tickClient() {
        new ArrayList<ITickable>(CLIENT_TASKS).forEach(t -> t.addTick(1));
    }

    public static void tick(int ticks) {
        TASKS.forEach(task -> task.addTick(ticks));
    }

    public static void tickClient(int ticks) {
        CLIENT_TASKS.forEach(task -> task.addTick(ticks));
    }

    public static void checkAndRemove() {
        TASKS.removeIf(ITickable::isRemoved);
    }

    public static void checkAndRemoveClient() {
        CLIENT_TASKS.removeIf(ITickable::isRemoved);
    }

    public static void executeDefault() {
        TickTasks.tick();
        TickTasks.checkAndRemove();
    }

    public static void executeDefaultClient() {
        TickTasks.tickClient();
        TickTasks.checkAndRemoveClient();
    }
}

