/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.ai;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cneko.toneko.common.mod.entities.INeko;
import org.cneko.toneko.common.mod.entities.NekoEntity;

public class PromptRegistry {
    private static final Map<String, PromptFactory> PROMPT_REGISTRY = new HashMap<String, PromptFactory>();

    public static PromptFactory register(String key, PromptFactory promptFactory) {
        PROMPT_REGISTRY.put(key, promptFactory);
        return promptFactory;
    }

    public static Collection<PromptFactory> getAll() {
        return PROMPT_REGISTRY.values();
    }

    public static String generatePrompt(NekoEntity neko, INeko other, String prompt) {
        if (prompt == null) {
            return "";
        }
        for (Map.Entry<String, PromptFactory> entry : PROMPT_REGISTRY.entrySet()) {
            String key = entry.getKey();
            String placeholder = "%" + key + "%";
            if (!prompt.contains(placeholder)) continue;
            String replacement = entry.getValue().getPrompt(neko, other);
            prompt = prompt.replace(placeholder, replacement);
        }
        return prompt;
    }

    public static interface PromptFactory {
        public String getPrompt(NekoEntity var1, INeko var2);
    }
}

