/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.toneko.common.mod.client.events;

import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.cneko.toneko.common.mod.client.api.ClientEntityPoseManager;
import org.cneko.toneko.common.mod.client.screens.InteractionScreen;
import org.cneko.toneko.common.mod.client.screens.NekoScreenRegistry;
import org.cneko.toneko.common.mod.client.screens.PlotScrollScreen;
import org.cneko.toneko.common.mod.client.screens.QuirkScreen;
import org.cneko.toneko.common.mod.client.util.ClientPlayerUtil;
import org.cneko.toneko.common.mod.entities.NekoEntity;
import org.cneko.toneko.common.mod.packets.EntityPosePayload;
import org.cneko.toneko.common.mod.packets.NekoInfoSyncPayload;
import org.cneko.toneko.common.mod.packets.OpenPlotScreenPayload;
import org.cneko.toneko.common.mod.packets.PlayerLeadByPlayerPayload;
import org.cneko.toneko.common.mod.packets.QuirkQueryPayload;
import org.cneko.toneko.common.mod.packets.TTSSendPayload;
import org.cneko.toneko.common.mod.packets.interactives.NekoEntityInteractivePayload;
import org.cneko.toneko.common.util.AIUtil;
import org.cneko.toneko.common.util.ConfigUtil;
import org.jetbrains.annotations.Nullable;

public class ClientNetworkEvents {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(EntityPosePayload.ID, (payload, context) -> context.client().execute(() -> ClientNetworkEvents.setPose(payload, context)));
        ClientPlayNetworking.registerGlobalReceiver(QuirkQueryPayload.ID, (payload, context) -> {
            if (payload.isOpenScreen()) {
                context.client().execute(() -> context.client().method_1507((class_437)new QuirkScreen(context.client().field_1755, payload.getQuirks(), payload.getAllQuirks())));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(NekoEntityInteractivePayload.ID, (payload, context) -> context.client().execute(() -> {
            NekoEntity neko;
            String uuid = payload.uuid();
            if (uuid != null && !uuid.isEmpty() && (neko = ClientNetworkEvents.findNearbyNekoByUuid(UUID.fromString(uuid), NekoEntity.DEFAULT_FIND_RANGE)) != null) {
                context.client().method_1507((class_437)new InteractionScreen((class_2561)class_2561.method_43473(), neko, class_310.method_1551().field_1755, NekoScreenRegistry.get(neko.method_5864())));
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(PlayerLeadByPlayerPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_1657 holder = ClientPlayerUtil.getPlayerByUUID(UUID.fromString(payload.holder()));
            class_1657 target = ClientPlayerUtil.getPlayerByUUID(UUID.fromString(payload.target()));
            if (target != null && holder != null) {
                target.method_60964((class_1297)holder, false);
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(TTSSendPayload.ID, (payload, context) -> context.client().execute(() -> {
            if (ConfigUtil.isAITTSEnabled()) {
                AIUtil.playTTS(payload.text(), ConfigUtil.getAITTSVoice());
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(NekoInfoSyncPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_746 player = context.player();
            player.setNekoEnergy(payload.energy());
        }));
        ClientPlayNetworking.registerGlobalReceiver(OpenPlotScreenPayload.ID, (payload, context) -> context.client().execute(() -> context.client().method_1507((class_437)new PlotScrollScreen())));
    }

    public static void setPose(EntityPosePayload payload, ClientPlayNetworking.Context context) {
        String uuid = payload.uuid();
        if (uuid == null) {
            return;
        }
        Object entity = uuid.equalsIgnoreCase("self") ? context.player() : ClientNetworkEvents.findNearbyEntityByUuid(UUID.fromString(uuid), 128.0);
        class_4050 pose = payload.pose();
        boolean status = payload.status();
        if (status) {
            ClientEntityPoseManager.setPose((class_1297)entity, pose);
        } else {
            ClientEntityPoseManager.remove((class_1297)entity);
        }
    }

    @Nullable
    public static NekoEntity findNearbyNekoByUuid(UUID targetUuid, double range) {
        class_1309 class_13092 = ClientNetworkEvents.findNearbyEntityByUuid(targetUuid, range);
        if (class_13092 instanceof NekoEntity) {
            NekoEntity nekoEntity = (NekoEntity)class_13092;
            return nekoEntity;
        }
        return null;
    }

    @Nullable
    public static class_1309 findNearbyEntityByUuid(UUID targetUuid, double range) {
        class_746 player = class_310.method_1551().field_1724;
        class_238 box = new class_238(player.method_23317() - range, player.method_23318() - range, player.method_23321() - range, player.method_23317() + range, player.method_23318() + range, player.method_23321() + range);
        class_1937 world = player.method_37908();
        for (class_1297 entity : world.method_8335((class_1297)player, box)) {
            if (!entity.method_5667().equals(targetUuid)) continue;
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                return le;
            }
            return null;
        }
        return null;
    }
}

